/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core;

import java.util.HashMap;
import java.util.Map;
import org.specrunner.ISRMapping;
import org.specrunner.ISpecRunnerFactory;
import org.specrunner.ISpecRunnerFactoryPlugin;
import org.specrunner.annotator.IAnnotatorFactory;
import org.specrunner.comparators.IComparatorManager;
import org.specrunner.concurrency.IConcurrentMapping;
import org.specrunner.configuration.IConfigurationFactory;
import org.specrunner.context.IBlockFactory;
import org.specrunner.context.IContextFactory;
import org.specrunner.context.IContextPopulator;
import org.specrunner.converters.IConverterManager;
import org.specrunner.dumper.ISourceDumperFactory;
import org.specrunner.expressions.IExpressionFactory;
import org.specrunner.features.IFeatureManager;
import org.specrunner.listeners.IListenerManager;
import org.specrunner.parameters.IAccessFactory;
import org.specrunner.pipeline.IChannelFactory;
import org.specrunner.pipeline.IPipelineFactory;
import org.specrunner.plugins.IPluginFactory;
import org.specrunner.properties.IPropertyLoader;
import org.specrunner.report.IReporterFactory;
import org.specrunner.result.IResultFactory;
import org.specrunner.reuse.IReuseManager;
import org.specrunner.runner.IRunnerFactory;
import org.specrunner.source.IBuilderFactory;
import org.specrunner.source.ISourceFactoryManager;
import org.specrunner.source.resource.IResourceManagerFactory;
import org.specrunner.transformer.ITransformerManager;
import org.specrunner.util.UtilLog;
import org.specrunner.util.aligner.IStringAlignerFactory;
import org.specrunner.util.cache.ICacheFactory;
import org.specrunner.util.output.IOutputFactory;
import org.specrunner.util.resources.ResourceFinder;
import org.specrunner.util.xom.IPresenterManager;

public class SRMappingDefault
implements ISRMapping {
    private Map<Class<?>, String> types = new HashMap();
    private Map<Class<?>, Object> map = new HashMap();

    public SRMappingDefault() {
        this.types.put(ResourceFinder.class, "org.specrunner.util.resources.ResourceFinder");
        this.types.put(IPropertyLoader.class, "org.specrunner.properties.core.PropertyLoaderImpl");
        this.types.put(IConfigurationFactory.class, "org.specrunner.configuration.core.ConfigurationFactoryImpl");
        this.types.put(IFeatureManager.class, "org.specrunner.features.core.FeatureManagerImpl");
        this.types.put(IConverterManager.class, "org.specrunner.converters.core.ConverterManagerImpl");
        this.types.put(IComparatorManager.class, "org.specrunner.comparators.core.ComparatorManagerImpl");
        this.types.put(IPresenterManager.class, "org.specrunner.util.xom.core.PresenterManagerImpl");
        this.types.put(IAccessFactory.class, "org.specrunner.parameters.core.AccessFactoryImpl");
        this.types.put(IConcurrentMapping.class, "org.specrunner.concurrency.core.ConcurrentMappingImpl");
        this.types.put(IResourceManagerFactory.class, "org.specrunner.source.resource.core.ResourceManagerFactoryImpl");
        this.types.put(ISourceFactoryManager.class, "org.specrunner.source.core.SourceFactoryManagerImpl");
        this.types.put(IBuilderFactory.class, "org.specrunner.source.core.BuilderFactoryImpl");
        this.types.put(ITransformerManager.class, "org.specrunner.transformer.core.TransformerManagerImpl");
        this.types.put(IPluginFactory.class, "org.specrunner.plugins.core.factories.PluginFactoryGroupDefault");
        this.types.put(IBlockFactory.class, "org.specrunner.context.core.BlockFactoryImpl");
        this.types.put(IExpressionFactory.class, "org.specrunner.expressions.core.ExpressionFactoryJanino");
        this.types.put(IContextFactory.class, "org.specrunner.context.core.ContextFactoryImpl");
        this.types.put(IContextPopulator.class, "org.specrunner.context.core.ContextPopulatorImpl");
        this.types.put(IRunnerFactory.class, "org.specrunner.runner.core.RunnerFactoryDefault");
        this.types.put(IResultFactory.class, "org.specrunner.result.core.ResultFactoryImpl");
        this.types.put(IAnnotatorFactory.class, "org.specrunner.annotator.core.AnnotatorFactoryDefault");
        this.types.put(ISourceDumperFactory.class, "org.specrunner.dumper.core.SourceDumperFactoryDefault");
        this.types.put(IListenerManager.class, "org.specrunner.listeners.core.ListenerManagerDefault");
        this.types.put(IReuseManager.class, "org.specrunner.reuse.core.ReusableManagerImpl");
        this.types.put(IChannelFactory.class, "org.specrunner.pipeline.core.ChannelFactoryImpl");
        this.types.put(IPipelineFactory.class, "org.specrunner.pipeline.core.PipelineFactoryCustom");
        this.types.put(IStringAlignerFactory.class, "org.specrunner.util.aligner.core.StringAlignerFactoryImpl");
        this.types.put(ICacheFactory.class, "org.specrunner.util.cache.core.CacheFactoryDefault");
        this.types.put(IReporterFactory.class, "org.specrunner.report.core.ReporterFactoryDefault");
        this.types.put(IOutputFactory.class, "org.specrunner.util.output.core.OutputFactoryDefault");
        this.types.put(ISpecRunnerFactory.class, "org.specrunner.core.SpecRunnerFactoryDefault");
        this.types.put(ISpecRunnerFactoryPlugin.class, "org.specrunner.core.SpecRunnerFactoryPluginDefault");
    }

    @Override
    public <T> T getDefault(Class<T> type) {
        long time = System.currentTimeMillis();
        Object result = this.map.get(type);
        if (result == null) {
            try {
                Class<?> c = Class.forName(this.types.get(type));
                result = c.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.map.put(type, result);
        if (UtilLog.LOG.isDebugEnabled()) {
            time = System.currentTimeMillis() - time;
            UtilLog.LOG.debug("Get default(" + type + ") time: " + time);
        }
        return type.cast(result);
    }
}

