/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core;

import java.io.File;
import org.specrunner.ISpecRunner;
import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.configuration.IConfiguration;
import org.specrunner.configuration.IConfigurationFactory;
import org.specrunner.core.SpecRunnerPipelineUtils;
import org.specrunner.core.pipes.PipeConfiguration;
import org.specrunner.core.pipes.PipeInput;
import org.specrunner.core.pipes.PipeResult;
import org.specrunner.dumper.core.AbstractSourceDumperFile;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IChannelFactory;
import org.specrunner.pipeline.IPipeline;
import org.specrunner.result.IResultSet;

public class SpecRunnerPipeline
implements ISpecRunner {
    @Override
    public IResultSet run(String input) throws SpecRunnerException {
        return this.doRun(input, SRServices.get(IConfigurationFactory.class).newConfiguration());
    }

    @Override
    public IResultSet run(String input, IConfiguration configuration) throws SpecRunnerException {
        return this.doRun(input, configuration);
    }

    @Override
    public IResultSet run(String input, String output, IConfiguration configuration) throws SpecRunnerException {
        File file = new File(output);
        configuration.add(AbstractSourceDumperFile.FEATURE_OUTPUT_DIRECTORY, file.getParentFile());
        configuration.add(AbstractSourceDumperFile.FEATURE_OUTPUT_NAME, file.getName());
        return this.doRun(input, configuration);
    }

    protected IResultSet doRun(String input, IConfiguration configuration) throws SpecRunnerException {
        try {
            IChannel channel = SRServices.get(IChannelFactory.class).newChannel();
            PipeConfiguration.bind(PipeInput.bind(channel, input), configuration);
            IPipeline pipe = SpecRunnerPipelineUtils.getPipeline(SRServices.get(), configuration, "specrunner.xml");
            return PipeResult.lookup(pipe.process(channel));
        }
        catch (Exception e) {
            throw new SpecRunnerException(e);
        }
    }
}

