/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core;

import java.util.HashMap;
import java.util.Map;
import org.specrunner.SRServices;
import org.specrunner.configuration.IConfiguration;
import org.specrunner.pipeline.IPipeline;
import org.specrunner.pipeline.IPipelineFactory;
import org.specrunner.pipeline.PipelineException;
import org.specrunner.util.UtilLog;

public final class SpecRunnerPipelineUtils {
    public static final String PIPELINE_FILENAME = "sr_pipeline";
    private static Map<String, IPipeline> pipelines = new HashMap<String, IPipeline>();

    private SpecRunnerPipelineUtils() {
    }

    public static IPipeline getPipeline(SRServices service, String file) throws PipelineException {
        return SpecRunnerPipelineUtils.getPipeline(service, null, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPipeline getPipeline(SRServices services, IConfiguration configuration, String defaultFile) throws PipelineException {
        IPipeline pipe = null;
        String name = String.valueOf(configuration == null ? defaultFile : configuration.get(PIPELINE_FILENAME, defaultFile));
        Map<String, IPipeline> map = pipelines;
        synchronized (map) {
            long time = System.currentTimeMillis();
            pipe = pipelines.get(name);
            if (pipe == null) {
                pipe = services.lookup(IPipelineFactory.class).newPipeline(name);
                pipelines.put(name, pipe);
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Pipe of '" + name + "' loaded in " + (System.currentTimeMillis() - time) + ".");
                }
            } else if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Pipe of '" + name + "' reused in " + (System.currentTimeMillis() - time) + ".");
            }
        }
        return pipe;
    }
}

