/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core;

import org.specrunner.ISpecRunnerPlugin;
import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.configuration.IConfiguration;
import org.specrunner.configuration.IConfigurationFactory;
import org.specrunner.core.SpecRunnerPipelineUtils;
import org.specrunner.core.pipes.PipeConfiguration;
import org.specrunner.core.pipes.PipeResult;
import org.specrunner.core.pipes.plugin.PipePlugin;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IChannelFactory;
import org.specrunner.pipeline.IPipeline;
import org.specrunner.pipeline.ProfilerPipeListener;
import org.specrunner.plugins.IPlugin;
import org.specrunner.result.IResultSet;

public class SpecRunnerPluginPipeline
implements ISpecRunnerPlugin {
    @Override
    public IResultSet run(IPlugin plugin) throws SpecRunnerException {
        return this.doRun(plugin, SRServices.get(IConfigurationFactory.class).newConfiguration());
    }

    @Override
    public IResultSet run(IPlugin plugin, IConfiguration configuration) throws SpecRunnerException {
        return this.doRun(plugin, configuration);
    }

    protected IResultSet doRun(IPlugin plugin, IConfiguration configuration) throws SpecRunnerException {
        try {
            IChannel channel = SRServices.get(IChannelFactory.class).newChannel();
            PipeConfiguration.bind(PipePlugin.bind(channel, plugin), configuration);
            IPipeline pipe = SpecRunnerPipelineUtils.getPipeline(SRServices.get(), configuration, "specrunner_plugin.xml");
            pipe.addPipelineListener(new ProfilerPipeListener());
            return PipeResult.lookup(pipe.process(channel));
        }
        catch (Exception e) {
            throw new SpecRunnerException(e);
        }
    }
}

