/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core.pipes;

import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.annotator.AnnotatorException;
import org.specrunner.annotator.IAnnotator;
import org.specrunner.annotator.IAnnotatorFactory;
import org.specrunner.pipeline.AbortException;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.InvalidTypeException;
import org.specrunner.pipeline.NotFoundException;
import org.specrunner.pipeline.PipelineException;

public class PipeAnnotator
implements IPipe {
    public static final String ANNOTATOR = "annotator";

    @Override
    public boolean check(IChannel channel) throws AbortException {
        return true;
    }

    @Override
    public IChannel process(IChannel channel) throws PipelineException {
        try {
            PipeAnnotator.bind(channel, this.createAnnotator());
        }
        catch (SpecRunnerException e) {
            throw new PipelineException(e);
        }
        return channel;
    }

    protected IAnnotator createAnnotator() throws AnnotatorException {
        return SRServices.get(IAnnotatorFactory.class).newAnnotator();
    }

    public static IChannel bind(IChannel channel, IAnnotator obj) {
        return channel.add(ANNOTATOR, obj);
    }

    public static IAnnotator lookup(IChannel channel) throws NotFoundException, InvalidTypeException {
        return channel.get(ANNOTATOR, IAnnotator.class);
    }
}

