/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core.pipes;

import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.context.ContextException;
import org.specrunner.context.IContext;
import org.specrunner.context.IContextFactory;
import org.specrunner.core.pipes.PipeRunner;
import org.specrunner.pipeline.AbortException;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.InvalidTypeException;
import org.specrunner.pipeline.NotFoundException;
import org.specrunner.pipeline.PipelineException;
import org.specrunner.runner.IRunner;
import org.specrunner.source.ISource;

public class PipeContext
implements IPipe {
    public static final String CONTEXT = "context";

    @Override
    public boolean check(IChannel channel) throws AbortException {
        return true;
    }

    @Override
    public IChannel process(IChannel channel) throws PipelineException {
        try {
            ISource source = (ISource)channel.get("source");
            IRunner runner = PipeRunner.lookup(channel);
            PipeContext.bind(channel, this.createContext(source, runner));
        }
        catch (SpecRunnerException e) {
            throw new PipelineException(e);
        }
        return channel;
    }

    protected IContext createContext(ISource source, IRunner runner) throws ContextException {
        return SRServices.get(IContextFactory.class).newContext(source, runner);
    }

    public static IChannel bind(IChannel channel, IContext obj) {
        return channel.add(CONTEXT, obj);
    }

    public static IContext lookup(IChannel channel) throws NotFoundException, InvalidTypeException {
        return channel.get(CONTEXT, IContext.class);
    }
}

