/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core.pipes;

import java.io.File;
import java.util.Map;
import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.concurrency.IConcurrentMapping;
import org.specrunner.core.pipes.PipeDumper;
import org.specrunner.core.pipes.PipeInput;
import org.specrunner.core.pipes.PipeModel;
import org.specrunner.core.pipes.PipeResult;
import org.specrunner.core.pipes.PipeSource;
import org.specrunner.pipeline.AbortException;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.PipelineException;
import org.specrunner.result.IResultSet;
import org.specrunner.util.output.IOutput;
import org.specrunner.util.output.IOutputFactory;

public class PipeDump
implements IPipe {
    @Override
    public boolean check(IChannel channel) throws AbortException {
        return true;
    }

    @Override
    public IChannel process(IChannel channel) throws PipelineException {
        try {
            this.messageBefore(PipeInput.lookup(channel));
            IResultSet result = PipeResult.lookup(channel);
            Map<String, Object> model = PipeModel.recover(channel);
            PipeDumper.lookup(channel).dump(PipeSource.lookup(channel), result, model);
            this.messageAfter(model, result);
        }
        catch (SpecRunnerException e) {
            throw new PipelineException(e);
        }
        return channel;
    }

    protected void messageBefore(String input) {
        IOutput out = SRServices.get(IOutputFactory.class).currentOutput();
        out.println("");
        out.println(" Input " + this.getNome() + ": " + (input != null ? input.replace('/', File.separatorChar) : "null"));
    }

    protected String getNome() {
        return "(" + SRServices.get(IConcurrentMapping.class).getThread() + ")";
    }

    protected void messageAfter(Map<String, Object> info, IResultSet result) {
        IOutput out = SRServices.get(IOutputFactory.class).currentOutput();
        out.printf("Result " + this.getNome() + ": %s \n", result.asString());
        out.printf("    In " + this.getNome() + ": %d ms \n", info.get("time"));
        out.printf("    At " + this.getNome() + ": %s \n", info.get("date"));
    }
}

