/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core.pipes;

import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.dumper.ISourceDumper;
import org.specrunner.dumper.ISourceDumperFactory;
import org.specrunner.dumper.SourceDumperException;
import org.specrunner.pipeline.AbortException;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.InvalidTypeException;
import org.specrunner.pipeline.NotFoundException;
import org.specrunner.pipeline.PipelineException;

public class PipeDumper
implements IPipe {
    public static final String DUMPER = "dumper";

    @Override
    public boolean check(IChannel channel) throws AbortException {
        return true;
    }

    @Override
    public IChannel process(IChannel channel) throws PipelineException {
        try {
            PipeDumper.bind(channel, this.createDumper());
        }
        catch (SpecRunnerException e) {
            throw new PipelineException(e);
        }
        return channel;
    }

    protected ISourceDumper createDumper() throws SourceDumperException {
        return SRServices.get(ISourceDumperFactory.class).newDumper();
    }

    public static IChannel bind(IChannel channel, ISourceDumper obj) {
        return channel.add(DUMPER, obj);
    }

    public static ISourceDumper lookup(IChannel channel) throws NotFoundException, InvalidTypeException {
        return channel.get(DUMPER, ISourceDumper.class);
    }
}

