/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core.pipes;

import org.specrunner.SRServices;
import org.specrunner.configuration.IConfiguration;
import org.specrunner.core.pipes.PipeConfiguration;
import org.specrunner.features.IFeatureManager;
import org.specrunner.pipeline.AbortException;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.InvalidTypeException;
import org.specrunner.pipeline.NotFoundException;
import org.specrunner.pipeline.PipelineException;

public class PipeFeatureManager
implements IPipe {
    public static final String FEATURE_MANAGER = "featureManager";

    @Override
    public boolean check(IChannel channel) throws AbortException {
        try {
            PipeConfiguration.lookup(channel);
        }
        catch (NotFoundException e) {
            throw new AbortException(e);
        }
        catch (InvalidTypeException e) {
            throw new AbortException(e);
        }
        return true;
    }

    @Override
    public IChannel process(IChannel channel) throws PipelineException {
        IFeatureManager features = this.createFeatureManager();
        IConfiguration configuration = PipeConfiguration.lookup(channel);
        features.setConfiguration(configuration);
        channel.add(FEATURE_MANAGER, features);
        return channel;
    }

    protected IFeatureManager createFeatureManager() {
        return SRServices.getFeatureManager();
    }

    public static IFeatureManager lookup(IChannel channel) throws NotFoundException, InvalidTypeException {
        return channel.get(FEATURE_MANAGER, IFeatureManager.class);
    }
}

