/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core.pipes;

import java.util.HashMap;
import java.util.Map;
import org.specrunner.core.pipes.PipeInput;
import org.specrunner.pipeline.AbortException;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.InvalidTypeException;
import org.specrunner.pipeline.NotFoundException;
import org.specrunner.pipeline.PipelineException;
import org.specrunner.util.UtilLog;

public class PipeModel
implements IPipe {
    public static final String MODEL = "model";
    public static final String TIME = "time";
    public static final String FREE = "free";
    public static final String TOTAL = "total";
    public static final String MAX = "max";

    @Override
    public boolean check(IChannel channel) throws AbortException {
        return true;
    }

    @Override
    public IChannel process(IChannel channel) throws PipelineException {
        channel.add(MODEL, this.create(channel));
        return channel;
    }

    protected Map<String, Object> create(IChannel channel) throws NotFoundException, InvalidTypeException {
        HashMap<String, Object> model;
        block2: {
            model = new HashMap<String, Object>();
            try {
                model.put("input", PipeInput.lookup(channel));
            }
            catch (Exception e) {
                if (!UtilLog.LOG.isTraceEnabled()) break block2;
                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
            }
        }
        model.put(TIME, System.currentTimeMillis());
        Runtime rt = Runtime.getRuntime();
        model.put(FREE, rt.freeMemory());
        model.put(TOTAL, rt.totalMemory());
        model.put(MAX, rt.maxMemory());
        return model;
    }

    public static Map<String, Object> recover(IChannel channel) throws NotFoundException, InvalidTypeException {
        return channel.get(MODEL, Map.class);
    }
}

