/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core.pipes;

import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.dumper.SourceDumperException;
import org.specrunner.pipeline.AbortException;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.InvalidTypeException;
import org.specrunner.pipeline.NotFoundException;
import org.specrunner.pipeline.PipelineException;
import org.specrunner.report.IReporter;
import org.specrunner.report.IReporterFactory;

public class PipeReporter
implements IPipe {
    public static final String REPORTER = "reporter";

    @Override
    public boolean check(IChannel channel) throws AbortException {
        return true;
    }

    @Override
    public IChannel process(IChannel channel) throws PipelineException {
        try {
            PipeReporter.bind(channel, this.createReporter());
        }
        catch (SpecRunnerException e) {
            throw new PipelineException(e);
        }
        return channel;
    }

    protected IReporter createReporter() throws SourceDumperException {
        return SRServices.get(IReporterFactory.class).newReporter();
    }

    public static IChannel bind(IChannel channel, IReporter obj) {
        return channel.add(REPORTER, obj);
    }

    public static IReporter lookup(IChannel channel) throws NotFoundException, InvalidTypeException {
        return channel.get(REPORTER, IReporter.class);
    }
}

