/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core.pipes;

import org.specrunner.SRServices;
import org.specrunner.features.IFeatureManager;
import org.specrunner.pipeline.AbortException;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.InvalidTypeException;
import org.specrunner.pipeline.NotFoundException;
import org.specrunner.pipeline.PipelineException;
import org.specrunner.result.IResultFactory;
import org.specrunner.result.IResultSet;

public class PipeResult
implements IPipe {
    public static final String RESULT = "result";

    @Override
    public boolean check(IChannel channel) throws AbortException {
        return true;
    }

    @Override
    public IChannel process(IChannel channel) throws PipelineException {
        PipeResult.bind(channel, this.createResult());
        return channel;
    }

    protected IResultSet createResult() {
        IResultSet result = SRServices.get(IResultFactory.class).newResult();
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(IResultSet.FEATURE_RECORD_SUCCESS, result);
        fm.set(IResultSet.FEATURE_EXPECTED_MESSAGES, result);
        fm.set(IResultSet.FEATURE_EXPECTED_SORTED, result);
        return result;
    }

    public static void bind(IChannel channel, IResultSet result) {
        channel.add(RESULT, result);
    }

    public static IResultSet lookup(IChannel channel) throws NotFoundException, InvalidTypeException {
        return channel.get(RESULT, IResultSet.class);
    }
}

