/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core.pipes;

import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.pipeline.AbortException;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.InvalidTypeException;
import org.specrunner.pipeline.NotFoundException;
import org.specrunner.pipeline.PipelineException;
import org.specrunner.runner.IRunner;
import org.specrunner.runner.IRunnerFactory;
import org.specrunner.runner.RunnerException;
import org.specrunner.source.ISource;

public class PipeRunner
implements IPipe {
    public static final String RUNNER = "runner";

    @Override
    public boolean check(IChannel channel) throws AbortException {
        return true;
    }

    @Override
    public IChannel process(IChannel channel) throws PipelineException {
        try {
            ISource source = (ISource)channel.get("source");
            PipeRunner.bind(channel, this.createRunner(source));
        }
        catch (SpecRunnerException e) {
            throw new PipelineException(e);
        }
        return channel;
    }

    protected IRunner createRunner(ISource source) throws RunnerException {
        return SRServices.get(IRunnerFactory.class).newRunner(source);
    }

    public static IChannel bind(IChannel channel, IRunner obj) {
        return channel.add(RUNNER, obj);
    }

    public static IRunner lookup(IChannel channel) throws NotFoundException, InvalidTypeException {
        return channel.get(RUNNER, IRunner.class);
    }
}

