/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.core.pipes;

import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.core.pipes.PipeInput;
import org.specrunner.pipeline.AbortException;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.InvalidTypeException;
import org.specrunner.pipeline.NotFoundException;
import org.specrunner.pipeline.PipelineException;
import org.specrunner.source.ISource;
import org.specrunner.source.ISourceFactoryManager;
import org.specrunner.source.SourceException;
import org.specrunner.source.resource.IResourceManager;
import org.specrunner.source.resource.ResourceException;

public class PipeSource
implements IPipe {
    public static final String SOURCE = "source";

    @Override
    public boolean check(IChannel channel) throws AbortException {
        return true;
    }

    @Override
    public IChannel process(IChannel channel) throws PipelineException {
        try {
            String input = PipeInput.lookup(channel);
            ISource source = this.createSource(input);
            this.addResources(source);
            PipeSource.bind(channel, source);
        }
        catch (SpecRunnerException e) {
            throw new PipelineException(e);
        }
        return channel;
    }

    protected ISource createSource(String input) throws SourceException {
        return SRServices.get(ISourceFactoryManager.class).newSource(input);
    }

    protected void addResources(ISource source) throws ResourceException {
        IResourceManager manager = source.getManager();
        manager.addDefaultCss();
        manager.addDefaultJs();
    }

    public static void bind(IChannel channel, ISource source) {
        channel.add(SOURCE, source);
    }

    public static ISource lookup(IChannel channel) throws NotFoundException, InvalidTypeException {
        return channel.get(SOURCE, ISource.class);
    }
}

