/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.dumper.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import nu.xom.Document;
import nu.xom.Serializer;
import org.specrunner.SRServices;
import org.specrunner.SpecRunnerException;
import org.specrunner.dumper.ISourceDumperFile;
import org.specrunner.dumper.SourceDumperException;
import org.specrunner.features.FeatureManagerException;
import org.specrunner.features.IFeatureManager;
import org.specrunner.result.IResultSet;
import org.specrunner.result.ResultException;
import org.specrunner.source.ISource;
import org.specrunner.source.ISourceFactoryManager;
import org.specrunner.source.core.EncodedImpl;
import org.specrunner.source.resource.IResource;
import org.specrunner.source.resource.IResourceManager;
import org.specrunner.util.UtilLog;

public abstract class AbstractSourceDumperFile
extends EncodedImpl
implements ISourceDumperFile {
    public static final int GAP = 4;
    protected File outputDirectory = DEFAULT_OUTPUT_DIRECTORY;
    protected String outputName = null;
    protected File outputFile;

    protected void set(ISource source, IResultSet result) throws SourceDumperException {
        this.setFeatures(source);
        this.outputFile = new File(this.outputDirectory + File.separator + this.outputName);
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    protected void setFeatures(ISource source) throws SourceDumperException {
        this.outputDirectory();
        this.outputName(source);
    }

    protected void outputDirectory() throws SourceDumperException {
        IFeatureManager fm = SRServices.getFeatureManager();
        try {
            fm.setStrict(FEATURE_OUTPUT_DIRECTORY, this);
        }
        catch (FeatureManagerException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new SourceDumperException(e);
        }
        if (this.outputDirectory == null) {
            throw new SourceDumperException("Output directory should be set.");
        }
        if (!this.outputDirectory.exists()) {
            if (!this.outputDirectory.mkdirs()) {
                throw new SourceDumperException("Could not create outputFile directory '" + this.outputDirectory + "'.");
            }
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Directory outputFile '" + this.outputDirectory + "' created.");
            }
        }
    }

    protected void outputName(ISource source) throws SourceDumperException {
        File asFile = source.getFile();
        if (asFile != null) {
            this.outputName = asFile.getName();
        }
        IFeatureManager fm = SRServices.getFeatureManager();
        try {
            fm.setStrict(FEATURE_OUTPUT_NAME, this);
        }
        catch (SpecRunnerException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new SourceDumperException(e);
        }
        if (this.outputName == null) {
            throw new SourceDumperException("Output file not set.");
        }
    }

    protected void clean(File file) throws ResultException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.clean(f);
            }
        }
        if (file.exists() && !file.delete()) {
            throw new ResultException("Could not delete " + (file.isDirectory() ? "directory" : "file") + " '" + file + "'.");
        }
    }

    protected String detailReport() {
        return this.outputName + "_res" + File.separator + this.outputName.substring(0, this.outputName.lastIndexOf(46)) + "_details.html";
    }

    protected Serializer getSerializer(OutputStream fr) throws UnsupportedEncodingException {
        return new Serializer(fr, this.getEncoding());
    }

    protected void saveTo(Document doc, File output) throws SourceDumperException {
        this.checkParent(output);
        FileOutputStream fout = null;
        FilterOutputStream bout = null;
        try {
            fout = new FileOutputStream(output);
            bout = new BufferedOutputStream(fout);
            this.getSerializer(bout).write(doc);
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new SourceDumperException(e);
        }
        finally {
            block18: {
                block17: {
                    if (fout != null) {
                        try {
                            fout.close();
                        }
                        catch (IOException e) {
                            if (!UtilLog.LOG.isTraceEnabled()) break block17;
                            UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (bout != null) {
                    try {
                        bout.close();
                    }
                    catch (IOException e) {
                        if (!UtilLog.LOG.isTraceEnabled()) break block18;
                        UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected void checkParent(File output) throws SourceDumperException {
        File parent = output.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new SourceDumperException("Could not create output directory '" + parent + "'.");
        }
    }

    protected void appendResources(File output) throws SourceDumperException {
        File res = new File(output.getAbsoluteFile() + "_res");
        try {
            this.clean(res);
            ISource ref = SRServices.get(ISourceFactoryManager.class).newSource(output.getAbsolutePath());
            IResourceManager manager = ref.getManager();
            manager.addDefaultCss();
            manager.addDefaultJs();
            for (IResource r : manager) {
                r.writeTo(ref);
            }
            this.saveTo(ref.getDocument(), output);
        }
        catch (Exception e) {
            throw new SourceDumperException(e);
        }
    }
}

