/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.dumper.core;

import java.io.File;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.specrunner.SRServices;
import org.specrunner.concurrency.IConcurrentMapping;
import org.specrunner.dumper.SourceDumperException;
import org.specrunner.dumper.core.AbstractSourceDumperFile;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.source.ISource;
import org.specrunner.source.SourceException;
import org.specrunner.util.UtilLog;
import org.specrunner.util.output.IOutput;
import org.specrunner.util.output.IOutputFactory;

public class SourceDumperCenter
extends AbstractSourceDumperFile {
    private static final int TAIL = 4;

    @Override
    public void dump(ISource source, IResultSet result, Map<String, Object> model) throws SourceDumperException {
        this.set(source, result);
        File output = new File(this.outputDirectory, this.outputName);
        model.put("output", String.valueOf(output));
        try {
            Document document = source.getDocument();
            this.addLinkToFrame(document, result, model);
            this.saveTo(document, output);
            IOutput out = SRServices.get(IOutputFactory.class).currentOutput();
            out.println("Output (" + SRServices.get(IConcurrentMapping.class).getThread() + "): " + output);
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("DEFAULT   SAVED TO " + output.getAbsolutePath());
            }
        }
        catch (SourceException e) {
            throw new SourceDumperException(e);
        }
    }

    protected void addLinkToFrame(Document document, IResultSet result, Map<String, Object> model) {
        Nodes nodes = document.query("//body");
        if (nodes.size() == 0) {
            nodes = new Nodes();
            nodes.append((Node)document.getRootElement());
        }
        Element body = (Element)nodes.get(0);
        int size = result.actionTypes().size() + 4;
        for (int i = 0; i < size; ++i) {
            body.insertChild((Node)new Element("br"), 0);
        }
        Element div = new Element("div");
        div.addAttribute(new Attribute("class", "sr_frame_link_div"));
        body.insertChild((Node)div, 0);
        Element span = new Element("span");
        span.addAttribute(new Attribute("id", "linkFrame"));
        span.addAttribute(new Attribute("class", "sr_frame_link_span"));
        div.appendChild((Node)span);
        Element link = new Element("a");
        span.appendChild((Node)link);
        link.addAttribute(new Attribute("href", this.detailReport()));
        link.addAttribute(new Attribute("title", "This is a detailed report."));
        link.appendChild("SpecRunner details");
        span.appendChild(" [");
        Status s = result.getStatus();
        span.appendChild(s.asNode());
        span.appendChild("(" + result.countStatus(new Status[]{s}) + ")");
        span.appendChild(" in " + model.get("time") + " ms]: ");
        span.appendChild((Node)new Element("br"));
        span.appendChild(" at " + model.get("date") + " ");
        span.appendChild((Node)new Element("br"));
        span.appendChild(result.asNode());
    }
}

