/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.dumper.core;

import java.io.File;
import java.text.NumberFormat;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.specrunner.context.IBlock;
import org.specrunner.dumper.SourceDumperException;
import org.specrunner.dumper.core.AbstractSourceDumperFile;
import org.specrunner.result.IResult;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.source.ISource;
import org.specrunner.util.xom.UtilNode;

public class SourceDumperDetails
extends AbstractSourceDumperFile {
    protected static final int MBYTES = 0x100000;

    @Override
    public void dump(ISource source, IResultSet result, Map<String, Object> model) throws SourceDumperException {
        this.set(source, result);
        File output = new File(this.outputDirectory, this.detailReport());
        Document doc = new Document(new Element("html"));
        this.body(result, model, doc.getRootElement());
        this.saveTo(doc, output);
        this.appendResources(output);
    }

    protected void body(IResultSet result, Map<String, Object> model, Element html) {
        Element body = new Element("body");
        html.appendChild((Node)body);
        this.header(result, model, body);
        body.appendChild((Node)new Element("hr"));
        this.details(result, body);
        body.appendChild((Node)new Element("hr"));
        this.footer(result, model, body);
    }

    protected void header(IResultSet result, Map<String, Object> model, Element body) {
        Element table = new Element("table");
        table.addAttribute(new Attribute("class", "sr_table"));
        body.appendChild((Node)table);
        Element tr = new Element("tr");
        table.appendChild((Node)tr);
        Element td = new Element("td");
        td.addAttribute(new Attribute("class", "sr_resume " + result.getStatus().getCssName()));
        tr.appendChild((Node)td);
        Element legend = new Element("span");
        legend.addAttribute(new Attribute("class", "sr_legend"));
        td.appendChild((Node)legend);
        Element name = new Element("span");
        name.addAttribute(new Attribute("class", "sr_name"));
        legend.appendChild((Node)name);
        name.appendChild("SpecRunner");
        Element spanTime = new Element("span");
        spanTime.addAttribute(new Attribute("class", "sr_milis"));
        legend.appendChild((Node)spanTime);
        spanTime.appendChild(" in " + model.get("time") + " ms");
        legend.appendChild((Node)new Element("br"));
        Element spanOn = new Element("span");
        spanOn.addAttribute(new Attribute("class", "sr_on"));
        legend.appendChild((Node)spanOn);
        spanOn.appendChild(" on " + model.get("date"));
        tr = new Element("tr");
        table.appendChild((Node)tr);
        td = new Element("td");
        tr.appendChild((Node)td);
        td.appendChild(result.asNode());
    }

    protected void details(IResultSet result, Element body) {
        for (Status s : result.availableStatus()) {
            Element status = new Element("div");
            status.addAttribute(new Attribute("class", s.getCssName() + " sr_status"));
            body.appendChild((Node)status);
            status.appendChild(s.getName());
            status.appendChild("(" + result.countStatus(new Status[]{s}) + ")");
            if (!s.isError()) continue;
            Element ul = new Element("ul");
            ul.addAttribute(new Attribute("class", "sr_status_list"));
            body.appendChild((Node)ul);
            for (IResult local : result.filterByStatus(new Status[]{s})) {
                IBlock block = local.getBlock();
                Node target = block.getNode();
                Nodes nodes = target.query("descendant::a[@name]");
                if (nodes.size() <= 0) continue;
                Element li = new Element("li");
                li.addAttribute(new Attribute("class", "sr_status_item"));
                Element link = new Element("a");
                String name = ((Element)UtilNode.getHighest(nodes)).getAttributeValue("name");
                link.addAttribute(new Attribute("href", this.outputName + "#" + name));
                link.addAttribute(new Attribute("id", "error" + name));
                li.appendChild((Node)link);
                if (!s.isError()) {
                    link.appendChild(name + "-" + s.getName());
                } else {
                    Throwable failure = local.getFailure();
                    String msg = null;
                    if (failure != null) {
                        msg = failure.getMessage();
                        if (msg == null) {
                            msg = "Null message.";
                        }
                    } else {
                        msg = "Failure missing.";
                    }
                    link.addAttribute(new Attribute("title", msg));
                    link.appendChild(name + "-" + msg);
                }
                ul.appendChild((Node)li);
            }
        }
    }

    protected void footer(IResultSet result, Map<String, Object> model, Element body) {
        Element table = new Element("table");
        table.addAttribute(new Attribute("class", "sr_table"));
        body.appendChild((Node)table);
        Element tr = new Element("tr");
        table.appendChild((Node)tr);
        Element td = new Element("td");
        tr.appendChild((Node)td);
        Runtime runtime = Runtime.getRuntime();
        double freeBefore = (Long)model.get("free") / 0x100000L;
        double totalBefore = (Long)model.get("total") / 0x100000L;
        double maxBefore = (Long)model.get("max") / 0x100000L;
        double freePercBefore = freeBefore / maxBefore;
        double totalPercBefore = totalBefore / maxBefore;
        double freeAfter = runtime.freeMemory() / 0x100000L;
        double totalAfter = runtime.totalMemory() / 0x100000L;
        double maxAfter = runtime.maxMemory() / 0x100000L;
        double freePercAfter = freeAfter / maxAfter;
        double totalPercAfter = totalAfter / maxAfter;
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMaximumFractionDigits(2);
        Element spanProcessors = new Element("span");
        spanProcessors.addAttribute(new Attribute("class", "sr_processors"));
        spanProcessors.appendChild("Processors:" + runtime.availableProcessors());
        td.appendChild((Node)spanProcessors);
        Element spanMax = new Element("span");
        spanMax.addAttribute(new Attribute("class", "sr_max_memory"));
        spanMax.appendChild(" | Max memory:" + maxAfter + " Mb.");
        td.appendChild((Node)spanMax);
        Element tableMem = new Element("table");
        tableMem.addAttribute(new Attribute("class", "sr_memory"));
        td.appendChild((Node)tableMem);
        Element trMem1 = new Element("tr");
        tableMem.appendChild((Node)trMem1);
        Element thMem1 = new Element("th");
        thMem1.appendChild("Memory");
        trMem1.appendChild((Node)thMem1);
        thMem1 = new Element("th");
        thMem1.appendChild("Before(Mb)");
        trMem1.appendChild((Node)thMem1);
        thMem1 = new Element("th");
        thMem1.appendChild("After(Mb)");
        trMem1.appendChild((Node)thMem1);
        thMem1 = new Element("th");
        thMem1.appendChild("Diff(Mb)");
        trMem1.appendChild((Node)thMem1);
        String patternMemory = "%.2f (%s)";
        Element trMem2 = new Element("tr");
        tableMem.appendChild((Node)trMem2);
        Element tdMem2 = new Element("td");
        tdMem2.appendChild("Free");
        trMem2.appendChild((Node)tdMem2);
        tdMem2 = new Element("td");
        tdMem2.appendChild(String.format(patternMemory, freeBefore, nf.format(freePercBefore)));
        trMem2.appendChild((Node)tdMem2);
        tdMem2 = new Element("td");
        tdMem2.appendChild(String.format(patternMemory, freeAfter, nf.format(freePercAfter)));
        trMem2.appendChild((Node)tdMem2);
        tdMem2 = new Element("td");
        tdMem2.appendChild(String.format("%.2f", freeAfter - freeBefore));
        trMem2.appendChild((Node)tdMem2);
        Element trMem3 = new Element("tr");
        tableMem.appendChild((Node)trMem3);
        Element tdMem3 = new Element("td");
        tdMem3.appendChild("Total");
        trMem3.appendChild((Node)tdMem3);
        tdMem3 = new Element("td");
        tdMem3.appendChild(String.format(patternMemory, totalBefore, nf.format(totalPercBefore)));
        trMem3.appendChild((Node)tdMem3);
        tdMem3 = new Element("td");
        tdMem3.appendChild(String.format(patternMemory, totalAfter, nf.format(totalPercAfter)));
        trMem3.appendChild((Node)tdMem3);
        tdMem3 = new Element("td");
        tdMem3.appendChild(String.format("%.2f", totalAfter - totalBefore));
        trMem3.appendChild((Node)tdMem3);
    }
}

