/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.dumper.core;

import java.io.File;
import java.util.Map;
import org.specrunner.SRServices;
import org.specrunner.dumper.SourceDumperException;
import org.specrunner.dumper.core.AbstractSourceDumperFile;
import org.specrunner.result.IResultSet;
import org.specrunner.source.ISource;
import org.specrunner.source.ISourceFactoryManager;
import org.specrunner.source.resource.IResource;
import org.specrunner.source.resource.IResourceManager;
import org.specrunner.util.UtilLog;

public class SourceDumperResources
extends AbstractSourceDumperFile {
    @Override
    public void dump(ISource source, IResultSet result, Map<String, Object> model) throws SourceDumperException {
        this.set(source, result);
        File res = new File(this.outputFile.getAbsoluteFile() + "_res");
        try {
            this.clean(res);
            if (!this.outputFile.exists() && !this.outputFile.createNewFile()) {
                throw new SourceDumperException("Output file could not be created.");
            }
            IResourceManager manager = source.getManager();
            ISource target = SRServices.get(ISourceFactoryManager.class).newSource(this.outputFile.getAbsolutePath());
            for (IResource r : manager) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("RESOURCE (" + r + "):" + res.getAbsolutePath());
                }
                r.writeTo(target);
            }
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("RESOURCES SAVED TO " + res.getAbsolutePath());
            }
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new SourceDumperException(e);
        }
    }
}

