/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.dumper.core;

import java.io.File;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.specrunner.context.IBlock;
import org.specrunner.dumper.SourceDumperException;
import org.specrunner.dumper.core.AbstractSourceDumperFile;
import org.specrunner.result.IResult;
import org.specrunner.result.IResultSet;
import org.specrunner.result.IWritable;
import org.specrunner.result.ResultException;
import org.specrunner.source.ISource;
import org.specrunner.util.UtilLog;

public class SourceDumperWritables
extends AbstractSourceDumperFile {
    public static final String LABEL_FIELD = "name";

    @Override
    public void dump(ISource source, IResultSet result, Map<String, Object> model) throws SourceDumperException {
        this.set(source, result);
        File dir = new File(this.outputFile.getAbsolutePath() + "_res/snapshots");
        if (!dir.exists() && !dir.mkdirs()) {
            throw new SourceDumperException("Could not create snapshot directory '" + dir + "'.");
        }
        try {
            this.clean(dir);
            int index = 0;
            for (IResult r : result) {
                this.addWritable(dir, index, r);
                ++index;
            }
            if (dir.exists() && UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("WRITABLES SAVED TO " + dir.getAbsolutePath());
            }
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new SourceDumperException(e);
        }
    }

    protected void addWritable(File dir, int index, IResult r) throws ResultException {
        block5: {
            if (r.hasWritable()) {
                IWritable w = r.getWritable();
                if (!dir.exists() && !dir.mkdirs()) {
                    throw new ResultException("Could not create details outputFile directory " + dir + ".");
                }
                try {
                    File file = new File(dir, "" + index);
                    Map<String, String> references = w.writeTo(file.getAbsolutePath());
                    IBlock block = r.getBlock();
                    if (block.hasNode()) {
                        this.addElement(index, w, references, block);
                    }
                }
                catch (Exception e) {
                    if (!UtilLog.LOG.isDebugEnabled()) break block5;
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void addElement(int index, IWritable w, Map<String, String> references, IBlock block) {
        Node node = block.getNode();
        ParentNode parent = node instanceof ParentNode ? (ParentNode)node : node.getParent();
        for (Map.Entry<String, String> e : references.entrySet()) {
            parent.appendChild((Node)new Text(" "));
            Element link = new Element("a");
            link.addAttribute(new Attribute("class", "sr_" + e.getKey()));
            link.addAttribute(new Attribute("href", e.getValue()));
            link.addAttribute(new Attribute("target", e.getKey() + "_" + index));
            String text = w.hasInformation() ? (String)w.getInformation().get(LABEL_FIELD) : null;
            text = text != null ? e.getKey() + " " + text : e.getKey();
            link.appendChild(text);
            parent.appendChild((Node)link);
        }
    }
}

