/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.expressions.core;

import org.specrunner.context.IContext;
import org.specrunner.expressions.ExpressionException;
import org.specrunner.expressions.IExpressionFactory;
import org.specrunner.expressions.IExpressionItem;
import org.specrunner.util.UtilLog;

public class ExpressionItemClass
implements IExpressionItem {
    private static ThreadLocal<IExpressionItem> instance = new ThreadLocal<IExpressionItem>(){

        @Override
        protected IExpressionItem initialValue() {
            return new ExpressionItemClass();
        }
    };

    public static IExpressionItem get() {
        return instance.get();
    }

    @Override
    public Object eval(IExpressionFactory factory, String text, IContext context, boolean silent) throws ExpressionException {
        Object value = null;
        Class<?> clazz = factory.getClasses().get(text);
        if (clazz != null) {
            try {
                value = clazz.newInstance();
            }
            catch (Exception e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new ExpressionException("Unable to evaluate predefined value:" + text, e);
            }
        }
        return value;
    }
}

