/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.expressions.core;

import org.specrunner.context.IContext;
import org.specrunner.context.IModel;
import org.specrunner.expressions.ExpressionException;
import org.specrunner.expressions.IExpressionFactory;
import org.specrunner.expressions.IExpressionItem;
import org.specrunner.util.UtilLog;

public class ExpressionItemModel
implements IExpressionItem {
    private static ThreadLocal<IExpressionItem> instance = new ThreadLocal<IExpressionItem>(){

        @Override
        protected IExpressionItem initialValue() {
            return new ExpressionItemModel();
        }
    };

    public static IExpressionItem get() {
        return instance.get();
    }

    @Override
    public Object eval(IExpressionFactory factory, String text, IContext context, boolean silent) throws ExpressionException {
        Object value = null;
        IModel<?> model = factory.getModels().get(text);
        if (model != null) {
            try {
                value = model.getObject(context);
            }
            catch (Exception e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new ExpressionException("Unable to evaluate predefined model:" + text, e);
            }
        }
        return value;
    }
}

