/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.expressions.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.commons.compiler.IExpressionEvaluator;
import org.codehaus.janino.ExpressionEvaluator;
import org.codehaus.janino.Scanner;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.expressions.ExpressionException;
import org.specrunner.expressions.IExpression;
import org.specrunner.expressions.IExpressionFactory;
import org.specrunner.expressions.IExpressionItem;
import org.specrunner.expressions.core.AbstractExpression;
import org.specrunner.expressions.core.ExpressionKey;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.PluginException;
import org.specrunner.util.UtilLog;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;

public class ExpressionJanino
extends AbstractExpression {
    public static final String FEATURE_JDK_COMPILER = ExpressionJanino.class.getName() + ".jdk";
    private Object source;
    protected static ICache<ExpressionKey, IExpressionEvaluator> cache = SRServices.get(ICacheFactory.class).newCache(ExpressionJanino.class.getName());

    public ExpressionJanino(IExpressionFactory parent, Object source) {
        super(parent);
        this.source = source;
    }

    @Override
    public Object evaluate(IContext context, boolean silent) throws ExpressionException {
        LinkedList<Object> values;
        LinkedList types;
        LinkedList<String> args;
        String expression = String.valueOf(this.source);
        Object r = this.arguments(context, expression, args = new LinkedList<String>(), types = new LinkedList(), values = new LinkedList<Object>(), silent);
        if (r == null) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("EXPR>" + expression);
                UtilLog.LOG.debug("ARGS>" + args);
                UtilLog.LOG.debug("VALS>" + values);
                UtilLog.LOG.debug("TYPES>" + types);
            }
            r = this.eval(this.source, expression, args, types, values, silent);
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("JANINO(" + (r != null ? r.getClass().getSimpleName() : "") + ")>" + r);
            }
        } else if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("DIRECT(" + (r != null ? r.getClass().getSimpleName() : "") + ")>" + r);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    protected Object arguments(IContext context, String expression, List<String> args, List<Class<?>> types, List<Object> values, boolean silent) throws ExpressionException {
        block55: {
            if (expression.equals("")) {
                return "";
            }
            if (expression.equals("true")) {
                return Boolean.TRUE;
            }
            if (expression.equals("false")) {
                return Boolean.FALSE;
            }
            StringReader rd = null;
            try {
                String[] vars;
                rd = new StringReader(expression);
                try {
                    vars = ExpressionEvaluator.guessParameterNames((Scanner)new Scanner(null, (Reader)rd));
                }
                catch (Exception e) {
                    String string;
                    block50: {
                        if (UtilLog.LOG.isTraceEnabled()) {
                            UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                        }
                        if (!silent) {
                            throw new PluginException(e);
                        }
                        string = expression;
                        if (rd != null) {
                            try {
                                ((Reader)rd).close();
                            }
                            catch (IOException e2) {
                                if (UtilLog.LOG.isTraceEnabled()) {
                                    UtilLog.LOG.trace(e2.getMessage(), (Throwable)e2);
                                }
                                if (silent) break block50;
                                throw new ExpressionException(e2);
                            }
                        }
                    }
                    return string;
                }
                for (String str : vars) {
                    Object value = this.getValue(context, str, silent);
                    if (value != null) {
                        args.add(str);
                        values.add(value);
                        types.add(value.getClass());
                    }
                    if (!expression.equals(str)) continue;
                    if (values.isEmpty()) {
                        String string = expression;
                        return string;
                    }
                    Object object = values.get(0);
                    return object;
                }
                try {
                    Object arr$ = this.numericValue(expression);
                    return arr$;
                }
                catch (NumberFormatException ne) {
                    block51: {
                        Object string;
                        block54: {
                            block52: {
                                String string;
                                block53: {
                                    if (vars.length == args.size()) break block51;
                                    if (!silent) break block52;
                                    string = expression;
                                    if (rd == null) break block53;
                                    try {
                                        ((Reader)rd).close();
                                    }
                                    catch (IOException e) {
                                        if (UtilLog.LOG.isTraceEnabled()) {
                                            UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                                        }
                                        if (silent) break block53;
                                        throw new ExpressionException(e);
                                    }
                                }
                                return string;
                            }
                            string = null;
                            if (rd == null) break block54;
                            try {
                                ((Reader)rd).close();
                            }
                            catch (IOException e) {
                                if (UtilLog.LOG.isTraceEnabled()) {
                                    UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                                }
                                if (silent) break block54;
                                throw new ExpressionException(e);
                            }
                        }
                        return string;
                    }
                    if (rd == null) break block55;
                    try {
                        ((Reader)rd).close();
                        break block55;
                    }
                    catch (IOException e) {
                        if (UtilLog.LOG.isTraceEnabled()) {
                            UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                        }
                        if (!silent) {
                            throw new ExpressionException(e);
                        }
                        break block55;
                    }
                    catch (Exception e) {
                        if (UtilLog.LOG.isTraceEnabled()) {
                            UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                        }
                        if (!silent) {
                            throw new ExpressionException(e);
                        }
                        break block55;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                block56: {
                    if (rd != null) {
                        try {
                            ((Reader)rd).close();
                        }
                        catch (IOException e) {
                            if (UtilLog.LOG.isTraceEnabled()) {
                                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                            }
                            if (silent) break block56;
                            throw new ExpressionException(e);
                        }
                    }
                }
            }
        }
        return null;
    }

    protected Object getValue(IContext context, String text, boolean silent) throws ExpressionException {
        Object value = null;
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(IExpression.FEATURE_PRECEDENCE, this);
        IExpressionItem[] order = this.getPrecedence();
        for (int i = 0; i < order.length; ++i) {
            value = order[i].eval(this.getParent(), text, context, silent);
            if (value == null) continue;
            return value;
        }
        return value;
    }

    protected Object eval(Object source, String expression, List<String> args, List<Class<?>> types, List<Object> values, boolean silent) throws ExpressionException {
        Object r;
        block12: {
            String[] arrayArgs = new String[args.size()];
            args.toArray(arrayArgs);
            Object[] arrayValues = new Object[values.size()];
            values.toArray(arrayValues);
            Class[] arrayTypes = new Class[types.size()];
            types.toArray(arrayTypes);
            r = null;
            try {
                r = this.numericValue(expression);
            }
            catch (NumberFormatException ne) {
                if (UtilLog.LOG.isTraceEnabled()) {
                    UtilLog.LOG.trace(ne.getMessage(), (Throwable)ne);
                    UtilLog.LOG.trace("JANINO(" + source + ")_not a number>" + r);
                }
                try {
                    block11: {
                        long time = System.currentTimeMillis();
                        try {
                            r = this.tryObject(Object.class, expression, arrayArgs, arrayValues, arrayTypes);
                            if (UtilLog.LOG.isTraceEnabled()) {
                                UtilLog.LOG.trace("tryObject (Object.class...) succeed: " + (System.currentTimeMillis() - time));
                            }
                        }
                        catch (Exception e) {
                            if (UtilLog.LOG.isTraceEnabled()) {
                                UtilLog.LOG.trace("tryObject (Object.class...) failed: " + (System.currentTimeMillis() - time));
                            }
                            r = this.tryObject(Void.TYPE, expression, arrayArgs, arrayValues, arrayTypes);
                            if (!UtilLog.LOG.isTraceEnabled()) break block11;
                            UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug("JANINO(" + source + ")_produced>" + r + "(" + (r != null ? r.getClass().getSimpleName() : "") + ")");
                    }
                }
                catch (Exception e) {
                    if (!silent) {
                        throw new ExpressionException(e);
                    }
                    r = expression;
                    if (!UtilLog.LOG.isTraceEnabled()) break block12;
                    UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                    UtilLog.LOG.trace("JANINO(" + source + ")_unchanged>" + r);
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object tryObject(Class<?> returnType, String expression, String[] arrayArgs, Object[] arrayValues, Class<?>[] arrayTypes) throws Exception {
        Object ee = null;
        ICache<ExpressionKey, IExpressionEvaluator> iCache = cache;
        synchronized (iCache) {
            ee = cache.get(ExpressionKey.unique(expression, returnType, arrayArgs, arrayTypes));
            if (ee == null) {
                IFeatureManager fm;
                Boolean jdk;
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("NEW EXPRESSION(" + expression + ") before.");
                }
                ee = (jdk = (Boolean)(fm = SRServices.getFeatureManager()).get(FEATURE_JDK_COMPILER)) != null && jdk != false ? new org.codehaus.commons.compiler.jdk.ExpressionEvaluator(expression, returnType, arrayArgs, (Class[])arrayTypes) : new ExpressionEvaluator(expression, returnType, arrayArgs, (Class[])arrayTypes);
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("NEW EXPRESSION(" + expression + ") after new: " + ee);
                }
                cache.put(new ExpressionKey(expression, Object.class, arrayArgs, arrayTypes), (IExpressionEvaluator)ee);
            }
        }
        long time = System.currentTimeMillis();
        Object obj = ee.evaluate(arrayValues);
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("Time: " + (System.currentTimeMillis() - time));
        }
        return obj;
    }

    protected Number numericValue(String original) {
        try {
            return Long.valueOf(original);
        }
        catch (NumberFormatException e) {
            return Double.valueOf(original);
        }
    }
}

