/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.expressions.core;

import java.util.Arrays;

public class ExpressionKey {
    private static ThreadLocal<ExpressionKey> instance = new ThreadLocal<ExpressionKey>(){

        @Override
        protected ExpressionKey initialValue() {
            return new ExpressionKey();
        }
    };
    private String expression;
    private Class<?> returnType;
    private String[] arrayArgs;
    private Class<?>[] arrayTypes;

    public ExpressionKey() {
    }

    public ExpressionKey(String expression, Class<Object> returnType, String[] arrayArgs, Class<?>[] arrayTypes) {
        this.expression = expression;
        this.returnType = returnType;
        this.arrayArgs = arrayArgs == null ? null : Arrays.copyOf(arrayArgs, arrayArgs.length);
        this.arrayTypes = arrayTypes == null ? null : Arrays.copyOf(arrayTypes, arrayTypes.length);
    }

    public static ExpressionKey unique(String expression, Class<?> returnType, String[] arrayArgs, Class<?>[] arrayTypes) {
        ExpressionKey key = instance.get();
        key.expression = expression;
        key.returnType = returnType;
        key.arrayArgs = arrayArgs;
        key.arrayTypes = arrayTypes;
        return key;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        result = 31 * result + Arrays.hashCode(this.arrayArgs);
        result = 31 * result + Arrays.hashCode(this.arrayTypes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionKey other = (ExpressionKey)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType)) {
            return false;
        }
        if (!Arrays.equals(this.arrayArgs, other.arrayArgs)) {
            return false;
        }
        return Arrays.equals(this.arrayTypes, other.arrayTypes);
    }

    public String toString() {
        return this.expression + "," + this.returnType + ",(" + Arrays.toString(this.arrayArgs) + "),(" + Arrays.toString(this.arrayTypes) + ")";
    }
}

