/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.features.core;

import java.util.HashMap;
import java.util.Map;
import org.specrunner.SRServices;
import org.specrunner.configuration.IConfiguration;
import org.specrunner.features.FeatureManagerException;
import org.specrunner.features.IFeatureManager;
import org.specrunner.parameters.IAccess;
import org.specrunner.parameters.IAccessFactory;
import org.specrunner.util.UtilLog;

public class FeatureManagerImpl
extends HashMap<String, Object>
implements IFeatureManager {
    protected Map<String, Boolean> overrides = new HashMap<String, Boolean>();
    protected IConfiguration configuration;

    @Override
    public Object put(String key, Object value) {
        this.add(key, value);
        return super.put(key, value);
    }

    @Override
    public IFeatureManager add(String key, Object value) {
        this.add(key, value, true);
        return this;
    }

    @Override
    public IFeatureManager add(String key, Object value, boolean override) {
        super.put(key, value);
        this.overrides.put(key, override);
        return this;
    }

    @Override
    public Object get(Object key) {
        Object result;
        Object v0 = result = this.getConfiguration() != null ? this.getConfiguration().get(key) : null;
        if (result == null) {
            result = super.get(key);
        }
        return result;
    }

    @Override
    public void set(String feature, Object target) {
        block2: {
            try {
                this.setStrict(feature, target);
            }
            catch (FeatureManagerException e) {
                if (!UtilLog.LOG.isDebugEnabled()) break block2;
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setStrict(String feature, Object target) throws FeatureManagerException {
        Object value = this.get(feature);
        if (value != null) {
            String name = this.getField(feature);
            IAccess access = SRServices.get(IAccessFactory.class).newAccess(target, name);
            if (access == null) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Feature(" + target + "." + name + ") not found: ignoring attempt.");
                }
                return;
            }
            if (UtilLog.LOG.isTraceEnabled()) {
                UtilLog.LOG.trace("Access '" + access + "'.");
            }
            if (!access.valid(target, name, value)) {
                Class<?>[] types = access.expected(target, name, value);
                StringBuilder sb = new StringBuilder();
                for (Class<?> c : types) {
                    sb.append(String.valueOf(c));
                    sb.append(", ");
                }
                throw new FeatureManagerException("Object associated to " + feature + " is not a " + sb + ", current feature value '" + value + "' is " + value.getClass() + ".");
            }
            this.setValue(feature, value, target, name, access);
        }
    }

    protected String getField(String feature) throws FeatureManagerException {
        int pos = feature.lastIndexOf(46);
        if (pos < 0) {
            throw new FeatureManagerException("A feature should always end with a attribute name. i.e. '<any class name>.pause', current value:'" + feature + "'.");
        }
        return feature.substring(Math.min(pos + 1, feature.length())).trim();
    }

    protected void setValue(String feature, Object value, Object target, String field, IAccess access) throws FeatureManagerException {
        try {
            Boolean override = this.overrides.get(feature);
            if (override != null && !override.booleanValue()) {
                Object old = access.get(target, field, new Object[0]);
                if (old == null) {
                    access.set(target, field, value);
                }
            } else {
                access.set(target, field, value);
            }
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("Feature '" + feature + "' set to object '" + target + "', current value is " + value + ".");
            }
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("Error trying to set feature '" + feature + "' with value '" + value + "' to object '" + target + "' on field '" + field + "'.");
            }
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new FeatureManagerException(e);
        }
    }

    public IConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Object get(String key, Object defaultValue) {
        Object result = this.get(key);
        return result == null ? defaultValue : result;
    }
}

