/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.junit;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.runners.model.RunnerScheduler;
import org.specrunner.junit.Concurrent;
import org.specrunner.junit.NamedFactory;

public class ConcurrentRunnerScheduler
implements RunnerScheduler {
    public static final double RATE = 1.5;
    private final ExecutorService executorService;
    private final CompletionService<Integer> completionService;
    private final Queue<Future<Integer>> tasks = new LinkedList<Future<Integer>>();

    public ConcurrentRunnerScheduler(Class<?> klass) {
        this.executorService = Executors.newFixedThreadPool(klass.isAnnotationPresent(Concurrent.class) ? klass.getAnnotation(Concurrent.class).threads() : (int)((double)Runtime.getRuntime().availableProcessors() * 1.5), new NamedFactory(klass.getSimpleName()));
        this.completionService = new ExecutorCompletionService<Integer>(this.executorService);
    }

    public void schedule(Runnable childStatement) {
        this.tasks.offer(this.completionService.submit(childStatement, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        try {
            while (!this.tasks.isEmpty()) {
                this.tasks.remove(this.completionService.take());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            while (!this.tasks.isEmpty()) {
                this.tasks.poll().cancel(true);
            }
            this.executorService.shutdownNow();
        }
    }
}

