/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.junit;

import java.io.File;
import org.junit.Assert;
import org.specrunner.SRServices;
import org.specrunner.configuration.IConfiguration;
import org.specrunner.configuration.IConfigurationFactory;
import org.specrunner.dumper.core.AbstractSourceDumperFile;
import org.specrunner.result.IResultSet;
import org.specrunner.util.UtilLog;

public final class SpecRunnerJUnit {
    private SpecRunnerJUnit() {
    }

    public static void defaultRun(String input) {
        IConfiguration cfg = SRServices.get(IConfigurationFactory.class).newConfiguration();
        SpecRunnerJUnit.defaultRun(input, cfg);
    }

    public static void defaultRun(String input, IConfiguration cfg) {
        try {
            IResultSet result = SRServices.getSpecRunner().run(input, cfg);
            File dir = (File)SRServices.getFeatureManager().get(AbstractSourceDumperFile.FEATURE_OUTPUT_DIRECTORY);
            String file = (String)SRServices.getFeatureManager().get(AbstractSourceDumperFile.FEATURE_OUTPUT_NAME);
            Assert.assertTrue((String)((dir != null && file != null ? "OUTPUT: " + new File(dir, file).getAbsolutePath() + "\n" : "") + result.asString()), (!result.getStatus().isError() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            Assert.fail((String)e.getMessage());
        }
    }

    public static void defaultRun(String input, String output) {
        IConfiguration cfg = SRServices.get(IConfigurationFactory.class).newConfiguration();
        SpecRunnerJUnit.defaultRun(input, output, cfg);
    }

    public static void defaultRun(String input, String output, IConfiguration cfg) {
        File file = new File(output);
        cfg.add(AbstractSourceDumperFile.FEATURE_OUTPUT_DIRECTORY, file.getParentFile());
        cfg.add(AbstractSourceDumperFile.FEATURE_OUTPUT_NAME, file.getName());
        SpecRunnerJUnit.defaultRun(input, cfg);
    }
}

