/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.junit;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.specrunner.SRServices;
import org.specrunner.configuration.IConfiguration;
import org.specrunner.configuration.IConfigurationFactory;
import org.specrunner.junit.SpecRunnerJUnit;
import org.specrunner.util.UtilLog;

@RunWith(value=Parameterized.class)
public abstract class SpecRunnerParametrized {
    private final Entry entry;

    protected SpecRunnerParametrized(Entry entry) {
        this.entry = entry;
    }

    @Test
    public void run() {
        SpecRunnerJUnit.defaultRun(String.valueOf(this.entry.input), String.valueOf(this.entry.output), this.entry.cfg);
    }

    protected static Collection<Object[]> startsWith(File inDir, String prefix, File outDir) {
        return SpecRunnerParametrized.startsWith(inDir, prefix, outDir, SRServices.get(IConfigurationFactory.class).newConfiguration());
    }

    protected static Collection<Object[]> startsWith(File inDir, String prefix, File outDir, IConfiguration cfg) {
        return SpecRunnerParametrized.filter(inDir, prefix, Filter.STARTWITH, outDir, cfg);
    }

    protected static Collection<Object[]> contains(File inDir, String suffix, File outDir) {
        return SpecRunnerParametrized.contains(inDir, suffix, outDir, SRServices.get(IConfigurationFactory.class).newConfiguration());
    }

    protected static Collection<Object[]> contains(File inDir, String suffix, File outDir, IConfiguration cfg) {
        return SpecRunnerParametrized.filter(inDir, suffix, Filter.CONTAINS, outDir, cfg);
    }

    protected static Collection<Object[]> endsWith(File inDir, String suffix, File outDir) {
        return SpecRunnerParametrized.endsWith(inDir, suffix, outDir, SRServices.get(IConfigurationFactory.class).newConfiguration());
    }

    protected static Collection<Object[]> endsWith(File inDir, String suffix, File outDir, IConfiguration cfg) {
        return SpecRunnerParametrized.filter(inDir, suffix, Filter.ENDSWITH, outDir, cfg);
    }

    protected static Collection<Object[]> filter(File inDir, final String str, final Filter filter, File outDir, IConfiguration cfg) {
        if (!inDir.exists()) {
            throw new IllegalArgumentException("Diretory '" + inDir + "' not found.");
        }
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new IllegalArgumentException("Diretory '" + outDir + "' could not be created.");
        }
        File[] accepted = inDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                switch (filter) {
                    case STARTWITH: {
                        return name.startsWith(str);
                    }
                    case CONTAINS: {
                        return name.contains(str);
                    }
                    case ENDSWITH: {
                        return name.endsWith(str);
                    }
                }
                return false;
            }
        });
        LinkedList<Object[]> result = new LinkedList<Object[]>();
        for (File f : accepted) {
            result.add(new Object[]{new Entry(f, new File(outDir, f.getName()), cfg)});
            if (!UtilLog.LOG.isInfoEnabled()) continue;
            UtilLog.LOG.info((Object)((Object)filter) + "(" + str + "): test '" + f + "' added.");
        }
        return result;
    }

    protected static Collection<Object[]> merge(Collection<Object[]> ... lists) {
        LinkedList<Object[]> result = new LinkedList<Object[]>();
        if (lists != null) {
            LinkedList<Entry> list = new LinkedList<Entry>();
            for (Collection<Object[]> l : lists) {
                for (Object[] o : l) {
                    Entry e = (Entry)o[0];
                    if (!list.contains(e)) {
                        list.add(e);
                        result.add(o);
                        if (!UtilLog.LOG.isInfoEnabled()) continue;
                        UtilLog.LOG.info(" MERGE: test '" + e.input + "' added.");
                        continue;
                    }
                    if (!UtilLog.LOG.isInfoEnabled()) continue;
                    UtilLog.LOG.info("IGNORE: test '" + e.input + "' duplicated.");
                }
            }
        }
        return result;
    }

    static enum Filter {
        STARTWITH,
        CONTAINS,
        ENDSWITH;

    }

    protected static final class Entry {
        private final Object input;
        private final Object output;
        private final IConfiguration cfg;

        private Entry(Object input, Object output, IConfiguration cfg) {
            this.input = input;
            this.output = output;
            this.cfg = cfg;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cfg == null ? 0 : this.cfg.hashCode());
            result = 31 * result + (this.input == null ? 0 : this.input.hashCode());
            result = 31 * result + (this.output == null ? 0 : this.output.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return this.input.equals(other.input) && this.output.equals(other.output);
        }
    }
}

