/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.junit;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.LinkedList;
import java.util.Set;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.specrunner.ISpecRunner;
import org.specrunner.SRServices;
import org.specrunner.configuration.IConfiguration;
import org.specrunner.configuration.IConfigurationFactory;
import org.specrunner.dumper.core.AbstractSourceDumperFile;
import org.specrunner.junit.Configuration;
import org.specrunner.junit.ExpectedMessages;
import org.specrunner.junit.SRRunnerOptions;
import org.specrunner.result.IResultSet;
import org.specrunner.source.ISourceFactoryManager;
import org.specrunner.util.UtilLog;

public class SpecRunnerStatement
extends Statement {
    public static final String PATH = System.getProperty("sr.output", "target/output/");
    private TestClass test;
    private Object instance;
    private File input;
    private File output;

    public SpecRunnerStatement(TestClass test, Object instance) {
        this.test = test;
        this.instance = instance;
        Class clazz = test.getJavaClass();
        this.input = this.getFile(clazz);
        this.output = this.getOutput(clazz, this.input);
    }

    protected File getFile(Class<?> clazz) {
        File tmp;
        URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
        String str = location.toString();
        str = str.replace("file:\\\\", "").replace("file:///", "").replace("file:\\", "").replace("file:/", "");
        Package pkg = clazz.getPackage();
        if (pkg == null) {
            throw new RuntimeException("Test classe must be in a package.");
        }
        String prefix = str + pkg.getName().replace(".", File.separator) + File.separator + clazz.getSimpleName();
        Set extensions = SRServices.get(ISourceFactoryManager.class).keySet();
        for (String s : extensions) {
            tmp = new File(prefix + "." + s);
            if (!tmp.exists()) continue;
            return tmp;
        }
        prefix = str + pkg.getName().replace(".", File.separator) + File.separator + clazz.getSimpleName().replace("Test", "");
        for (String s : extensions) {
            tmp = new File(prefix + "." + s);
            if (!tmp.exists()) continue;
            return tmp;
        }
        throw new RuntimeException("File with one of extensions '" + extensions + "' to " + prefix + " not found!");
    }

    public File getOutput(Class<?> clazz, File input) {
        return new File(new File(PATH + clazz.getPackage().getName().replace('.', File.separatorChar)).getAbsoluteFile(), input.getName());
    }

    public void evaluate() throws Throwable {
        IConfiguration cfg = SRServices.get(IConfigurationFactory.class).newConfiguration();
        ISpecRunner srunner = SRServices.getSpecRunner();
        IResultSet result = srunner.run(this.input.getPath(), this.configure(cfg));
        if (result.getStatus().isError()) {
            throw new Exception("OUTPUT: " + this.output.getAbsoluteFile() + "\n" + result.asString());
        }
    }

    protected ExpectedMessages getMessages() {
        Annotation[] ans;
        for (Annotation an : ans = this.test.getAnnotations()) {
            if (!(an instanceof ExpectedMessages)) continue;
            return (ExpectedMessages)an;
        }
        return null;
    }

    protected IConfiguration configure(IConfiguration cfg) throws Throwable {
        Annotation[] ans;
        for (Annotation a : ans = this.instance.getClass().getAnnotations()) {
            if (!(a instanceof SRRunnerOptions)) continue;
            SRRunnerOptions options = (SRRunnerOptions)a;
            cfg.add("sr_pipeline", options.pipeline());
        }
        cfg.add("$THIS", this.instance);
        cfg.add(AbstractSourceDumperFile.FEATURE_OUTPUT_DIRECTORY, this.output.getParentFile());
        cfg.add(AbstractSourceDumperFile.FEATURE_OUTPUT_NAME, this.getOutputName(this.output.getName()));
        ExpectedMessages expected = this.getMessages();
        if (expected != null) {
            cfg.add(IResultSet.FEATURE_EXPECTED_MESSAGES, expected.value());
            cfg.add(IResultSet.FEATURE_EXPECTED_SORTED, expected.sorted());
        }
        Method[] ms = this.instance.getClass().getMethods();
        LinkedList<Method> candidates = new LinkedList<Method>();
        for (Method m : ms) {
            Configuration c = m.getAnnotation(Configuration.class);
            if (c == null) continue;
            candidates.add(m);
        }
        for (Method m : candidates) {
            Class<?>[] types = m.getParameterTypes();
            if (types.length == 1 && types[0] == IConfiguration.class) {
                m.invoke(this.instance, cfg);
                continue;
            }
            if (!UtilLog.LOG.isInfoEnabled()) continue;
            UtilLog.LOG.info("Invalid @Configuration method '" + m + "'");
        }
        return cfg;
    }

    public String getOutputName(String name) {
        if (name != null && name.contains(".") && !name.endsWith(".html")) {
            return name.substring(0, name.lastIndexOf(46)) + ".html";
        }
        return name;
    }
}

