/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.listeners.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.specrunner.listeners.core.ErrorFrameListener;

public class ErrorFrame
extends JFrame {
    private static final int FONT_SIZE = 12;
    private static final int GAPS = 10;
    private JTextArea text;
    private JDialog dialog;

    public ErrorFrame(ErrorFrameListener listener) {
        super("Error messages");
        this.setDefaultCloseOperation(1);
        this.createText();
        this.createDialog();
        this.createButtons(listener);
    }

    protected void createText() {
        this.text = new JTextArea();
        this.text.setEditable(false);
        this.text.setFont(new Font("Courrier New", 0, this.getFontSize()));
    }

    protected int getFontSize() {
        return 12;
    }

    protected void createDialog() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog = new JDialog((Frame)this, "Error messages");
        this.dialog.setSize(screenSize.width / 2, screenSize.height / 2);
        this.dialog.setLocation(screenSize.width / 2, screenSize.height / 2);
        this.dialog.setLayout(new BorderLayout(10, 10));
        this.dialog.add((Component)new JScrollPane(this.text), "Center");
        this.dialog.setModal(true);
    }

    protected void createButtons(final ErrorFrameListener listener) {
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(1, 10, 10));
        this.dialog.add((Component)buttons, "South");
        JButton ok = new JButton("Ok");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.ok();
                ErrorFrame.this.dialog.setVisible(false);
            }
        });
        buttons.add(ok);
        JButton okAll = new JButton("Ok to All");
        okAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.okToAll();
                ErrorFrame.this.dialog.setVisible(false);
            }
        });
        buttons.add(okAll);
    }

    public void setVisible(Object content) {
        this.text.setText(String.valueOf(content));
        this.setVisible(true);
        this.dialog.setVisible(true);
        this.setVisible(false);
    }
}

