/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.listeners.core;

import java.util.LinkedList;
import java.util.List;
import org.specrunner.listeners.IListenerManager;
import org.specrunner.listeners.ISpecRunnerListener;

public class ListenerManagerImpl
extends LinkedList<ISpecRunnerListener>
implements IListenerManager {
    @Override
    public void reset() {
        for (ISpecRunnerListener li : this) {
            li.reset();
        }
    }

    @Override
    public boolean add(ISpecRunnerListener e) {
        this.remove(e);
        return super.add(e);
    }

    @Override
    public void remove(String name) {
        ISpecRunnerListener listener = null;
        for (ISpecRunnerListener li : this) {
            if (!li.getName().equals(name)) continue;
            listener = li;
            break;
        }
        if (listener != null) {
            this.remove(listener);
        }
    }

    @Override
    public <T extends ISpecRunnerListener> List<T> filterByType(Class<T> type) {
        LinkedList<T> result = new LinkedList<T>();
        for (ISpecRunnerListener lis : this) {
            if (!type.isAssignableFrom(lis.getClass())) continue;
            result.add(type.cast(lis));
        }
        return result;
    }
}

