/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.listeners.core;

import java.io.IOException;
import java.util.List;
import nu.xom.Node;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.listeners.core.AbstractNodeListener;
import org.specrunner.listeners.core.ErrorFrame;
import org.specrunner.listeners.core.ErrorFrameListener;
import org.specrunner.plugins.ENext;
import org.specrunner.result.IResult;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.util.UtilIO;
import org.specrunner.util.UtilLog;

public class PauseOnFailureNodeListener
extends AbstractNodeListener
implements ErrorFrameListener {
    public static final String FEATURE_PAUSE_ON_FAILURE = PauseOnFailureNodeListener.class.getName() + ".pauseOnFailure";
    private Boolean pauseOnFailure = Boolean.FALSE;
    public static final String FEATURE_SHOW_DIALOG = PauseOnFailureNodeListener.class.getName() + ".showDialog";
    private Boolean showDialog = Boolean.FALSE;
    private ErrorFrame frame;
    private Boolean okToAll;
    private int start;

    @Override
    public String getName() {
        return "errorListener";
    }

    public Boolean getPauseOnFailure() {
        return this.pauseOnFailure;
    }

    public void setPauseOnFailure(Boolean pauseOnFailure) {
        this.pauseOnFailure = pauseOnFailure;
    }

    public Boolean getShowDialog() {
        return this.showDialog;
    }

    public void setShowDialog(Boolean showDialog) {
        this.showDialog = showDialog;
    }

    @Override
    public void reset() {
        this.pauseOnFailure = false;
        this.showDialog = false;
        this.okToAll = false;
    }

    @Override
    public ENext onBefore(Node node, IContext context, IResultSet result) {
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_PAUSE_ON_FAILURE, this);
        fm.set(FEATURE_SHOW_DIALOG, this);
        this.start = result.size();
        return ENext.DEEP;
    }

    @Override
    public void onAfter(Node node, IContext context, IResultSet result) {
        block9: {
            if (this.pauseOnFailure.booleanValue() && !this.okToAll.booleanValue()) {
                List<Status> status = result.errorStatus();
                Status[] array = status.toArray(new Status[status.size()]);
                List errors = result.filterByStatus(this.start, result.size(), array);
                if (!errors.isEmpty()) {
                    try {
                        if (UtilLog.LOG.isInfoEnabled()) {
                            UtilLog.LOG.info("Error pause enabled.");
                        }
                        StringBuilder sb = new StringBuilder();
                        for (IResult e : errors) {
                            sb.append(e.asString());
                        }
                        if (UtilLog.LOG.isInfoEnabled()) {
                            UtilLog.LOG.info("Errors:" + sb);
                        }
                        if (this.showDialog.booleanValue()) {
                            this.showDialog(sb);
                        } else {
                            UtilIO.pressKey();
                        }
                    }
                    catch (IOException e) {
                        if (!UtilLog.LOG.isDebugEnabled()) break block9;
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected void showDialog(StringBuilder sb) {
        if (this.frame == null) {
            this.frame = new ErrorFrame(this);
        }
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Click one of the dialog buttons to move on.");
        }
        this.frame.setVisible(sb);
    }

    @Override
    public void ok() {
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("'Ok' pressed.");
        }
    }

    @Override
    public void okToAll() {
        this.okToAll = true;
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("'Ok to All' pressed.");
        }
    }
}

