/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.listeners.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.listeners.IPluginListener;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.IPlugin;
import org.specrunner.result.IResultSet;
import org.specrunner.util.UtilLog;
import org.specrunner.util.xom.UtilNode;

public class ProfilerPluginListener
implements IPluginListener {
    private static final int TRESHOLD = 5;
    private final Stack<Long> timeInit = new Stack();
    private final Stack<Long> timeStart = new Stack();
    private final Stack<Long> timeEnd = new Stack();
    private Long lastInit;
    private Long lastStart;
    private Long totalInit = 0L;
    private Long totalStart = 0L;
    private Long totalEnd = 0L;
    private Map<ActionType, Long> timeByType = new HashMap<ActionType, Long>();

    @Override
    public String getName() {
        return "profilerPlugin";
    }

    @Override
    public void reset() {
        this.timeInit.clear();
        this.timeStart.clear();
        this.timeEnd.clear();
        this.totalInit = 0L;
        this.totalStart = 0L;
        this.totalEnd = 0L;
        this.timeByType.clear();
    }

    @Override
    public void onBeforeInit(IPlugin plugin, IContext context, IResultSet result) {
        this.timeInit.push(System.currentTimeMillis());
    }

    @Override
    public void onAfterInit(IPlugin plugin, IContext context, IResultSet result) {
        this.lastInit = System.currentTimeMillis() - this.timeInit.pop();
        if (UtilLog.LOG.isDebugEnabled() && this.lastInit > 5L) {
            UtilLog.LOG.debug("initialize(): " + this.lastInit + "mls. On " + context.getPlugin());
        }
        this.totalInit = this.totalInit + this.lastInit;
    }

    @Override
    public void onBeforeStart(IPlugin plugin, IContext context, IResultSet result) {
        this.timeStart.push(System.currentTimeMillis());
    }

    @Override
    public void onAfterStart(IPlugin plugin, IContext context, IResultSet result) {
        this.lastStart = System.currentTimeMillis() - this.timeStart.pop();
        if (UtilLog.LOG.isDebugEnabled() && this.lastStart > 5L) {
            UtilLog.LOG.debug("doStart(): " + this.lastStart + "mls. On " + context.getPlugin());
        }
        this.totalStart = this.totalStart + this.lastStart;
    }

    @Override
    public void onBeforeEnd(IPlugin plugin, IContext context, IResultSet result) {
        this.timeEnd.push(System.currentTimeMillis());
    }

    @Override
    public void onAfterEnd(IPlugin plugin, IContext context, IResultSet result) {
        Long lastEnd = System.currentTimeMillis() - this.timeEnd.pop();
        if (UtilLog.LOG.isDebugEnabled() && lastEnd > 5L) {
            UtilLog.LOG.debug("  doEnd(): " + lastEnd + "mls. On " + context.getPlugin());
        }
        this.totalEnd = this.totalEnd + lastEnd;
        IBlock peek = (IBlock)context.peek();
        if (UtilLog.LOG.isDebugEnabled() && peek.hasPlugin() && peek.getNode() instanceof Element) {
            IPlugin p = peek.getPlugin();
            ActionType actionType = p.getActionType();
            String name = p.getClass().getSimpleName();
            Long time = this.timeByType.get(actionType);
            if (time == null) {
                time = 0L;
            }
            this.timeByType.put(actionType, time + (this.lastInit + this.lastStart + lastEnd));
            Element e = (Element)peek.getNode();
            UtilNode.appendCss((Node)e, "sr_time");
            e.addAttribute(new Attribute("srtime", (UtilLog.LOG.isTraceEnabled() ? name : "") + "\n(" + actionType.getName() + ")" + ":" + (this.lastInit > 0L ? this.lastInit : "") + "/" + (this.lastStart > 0L ? this.lastStart : "") + "/" + (lastEnd > 0L ? lastEnd : "")));
        }
    }

    public Map<ActionType, Long> getTimeByType() {
        return this.timeByType;
    }
}

