/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.listeners.core;

import java.util.Stack;
import org.specrunner.context.IContext;
import org.specrunner.listeners.ISourceListener;
import org.specrunner.result.IResultSet;
import org.specrunner.source.ISource;
import org.specrunner.util.UtilLog;

public class ProfilerSourceListener
implements ISourceListener {
    private final Stack<Long> timeStart = new Stack();

    @Override
    public String getName() {
        return "profilerSource";
    }

    @Override
    public void reset() {
        this.timeStart.clear();
    }

    @Override
    public void onBefore(ISource source, IContext context, IResultSet result) {
        this.timeStart.push(System.currentTimeMillis());
    }

    @Override
    public void onAfter(ISource source, IContext context, IResultSet result) {
        long time = System.currentTimeMillis() - this.timeStart.pop();
        if (UtilLog.LOG.isInfoEnabled() && source != null && time > 0L) {
            UtilLog.LOG.info("Source '" + source.getString() + "' performed in " + time + "mls.");
        }
    }
}

