/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.parameters.core;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.beanutils.PropertyUtils;
import org.specrunner.SRServices;
import org.specrunner.parameters.IAccess;
import org.specrunner.parameters.IAccessFactory;
import org.specrunner.parameters.core.AccessImpl;
import org.specrunner.util.UtilLog;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;

public class AccessFactoryImpl
implements IAccessFactory {
    protected ICache<String, IAccess> cache;

    @Override
    public IAccess newAccess(Object target, String name) {
        if (target == null) {
            return null;
        }
        Class<?> c = target.getClass();
        String key = c.getName() + "." + name;
        if (this.cache == null) {
            this.cache = SRServices.get(ICacheFactory.class).newCache(AccessFactoryImpl.class.getSimpleName());
        }
        if (this.cache.contains(key)) {
            return this.cache.get(key);
        }
        IAccess access = this.lookupBean(target, name);
        if (access == null) {
            access = this.lookupField(c, name);
        }
        if (access == null) {
            access = this.lookupMethod(c, name);
        }
        this.cache.put(key, access);
        return access;
    }

    protected IAccess lookupBean(Object target, String name) {
        AccessImpl access;
        block3: {
            access = null;
            try {
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)target, (String)name);
                if (pd != null && pd.getWriteMethod() != null) {
                    access = new AccessImpl(pd);
                }
            }
            catch (Exception e) {
                if (!UtilLog.LOG.isTraceEnabled()) break block3;
                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
            }
        }
        return access;
    }

    protected IAccess lookupField(Class<?> clazz, String name) {
        AccessImpl access;
        block6: {
            access = null;
            try {
                Field f = clazz.getDeclaredField(name);
                if (f != null) {
                    if (Modifier.isPublic(f.getModifiers())) {
                        access = new AccessImpl(f);
                    } else if (UtilLog.LOG.isTraceEnabled()) {
                        UtilLog.LOG.trace("Field '" + f.getName() + "' is not accessible. " + f);
                    }
                }
            }
            catch (Exception e) {
                if (!UtilLog.LOG.isTraceEnabled()) break block6;
                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
            }
        }
        return access;
    }

    protected IAccess lookupMethod(Class<?> clazz, String name) {
        AccessImpl access;
        block5: {
            access = null;
            try {
                Method m = null;
                for (Method i : clazz.getDeclaredMethods()) {
                    if (!i.getName().equals(name)) continue;
                    if (Modifier.isPublic(i.getModifiers())) {
                        m = i;
                        break;
                    }
                    if (!UtilLog.LOG.isTraceEnabled()) break;
                    UtilLog.LOG.trace("Method '" + i.getName() + "' is not accessible. " + i);
                    break;
                }
                if (m != null) {
                    access = new AccessImpl(m);
                }
            }
            catch (Exception e) {
                if (!UtilLog.LOG.isTraceEnabled()) break block5;
                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
            }
        }
        return access;
    }
}

