/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.parameters.core;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.BeanUtils;
import org.specrunner.converters.UtilConverter;
import org.specrunner.parameters.IAccess;
import org.specrunner.plugins.PluginException;

public class AccessImpl
implements IAccess {
    private Field field;
    private PropertyDescriptor property;
    private Method method;

    public AccessImpl(Field field) {
        this.field = field;
    }

    public AccessImpl(PropertyDescriptor property) {
        this.property = property;
    }

    public AccessImpl(Method method) {
        this.method = method;
    }

    @Override
    public void set(Object target, String name, Object ... args) throws Exception {
        if (target == null) {
            return;
        }
        if (this.field != null) {
            this.field.set(target, this.prepare(args[0]));
        } else if (this.property != null) {
            BeanUtils.setProperty((Object)target, (String)name, (Object)this.prepare(args[0]));
        } else if (this.method != null) {
            this.method.invoke(target, this.prepare(args));
        }
    }

    private Object[] prepare(Object[] args) throws PluginException {
        if (args == null) {
            return null;
        }
        if (args.length == 0) {
            return args;
        }
        args[0] = this.prepare(args[0]);
        return args;
    }

    private Object prepare(Object object) throws PluginException {
        if (object == null) {
            return null;
        }
        Class<?> type = null;
        Annotation[] annotations = null;
        if (this.field != null) {
            type = this.field.getType();
            annotations = this.field.getAnnotations();
        }
        if (this.property != null) {
            type = this.property.getPropertyType();
            annotations = this.getMethodAnnotations(this.property.getWriteMethod());
        }
        if (this.method != null) {
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            type = parameterTypes.length > 0 ? parameterTypes[0] : null;
            annotations = this.getMethodAnnotations(this.method);
        }
        if (type != null && !type.isInstance(object)) {
            object = UtilConverter.prepareArgument(this.toString(), annotations, type, object);
        }
        return object;
    }

    protected Annotation[] getMethodAnnotations(Method method) {
        Annotation[] annotations = method.getAnnotations();
        if (UtilConverter.getConverter(annotations) == null) {
            annotations = method.getParameterAnnotations()[0];
        }
        return annotations;
    }

    @Override
    public Object get(Object target, String name, Object ... args) throws Exception {
        if (target == null) {
            return null;
        }
        if (this.field != null) {
            return this.field.get(target);
        }
        if (this.property != null) {
            return BeanUtils.getProperty((Object)target, (String)name);
        }
        if (this.method != null) {
            return this.method.invoke(target, args);
        }
        return null;
    }

    @Override
    public boolean valid(Object target, String name, Object ... args) {
        Class<?>[] types = this.expected(target, name, args);
        boolean valid = true;
        for (int i = 0; valid && args != null && i < types.length && i < args.length; ++i) {
            valid = valid && (args[i] == null || types[i].isAssignableFrom(args[i].getClass()));
        }
        return valid;
    }

    @Override
    public Class<?>[] expected(Object target, String name, Object ... args) {
        if (this.field != null) {
            return new Class[]{this.field.getType()};
        }
        if (this.property != null) {
            return new Class[]{this.property.getPropertyType()};
        }
        if (this.method != null) {
            return this.method.getParameterTypes();
        }
        return new Class[0];
    }

    @Override
    public boolean hasFeature() {
        return this.field != null || this.property != null || this.method != null;
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.field != null) {
            return this.field.getAnnotations();
        }
        if (this.property != null) {
            Method writeMethod = this.property.getWriteMethod();
            if (writeMethod != null) {
                return writeMethod.getAnnotations();
            }
        } else if (this.method != null) {
            return this.method.getAnnotations();
        }
        return new Annotation[0];
    }

    public String toString() {
        return "Access: " + (this.field != null ? this.field : (this.property != null ? this.property.getPropertyType() + ":" + this.property.getName() + ":" + this.property.getReadMethod() + ":" + this.property.getWriteMethod() : (this.method != null ? this.method : null)));
    }
}

