/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.parameters.core;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.expressions.Late;
import org.specrunner.expressions.Unsilent;
import org.specrunner.parameters.DontEval;
import org.specrunner.parameters.IAccess;
import org.specrunner.parameters.IAccessFactory;
import org.specrunner.parameters.IParameterDecorator;
import org.specrunner.plugins.PluginException;
import org.specrunner.util.UtilEvaluator;
import org.specrunner.util.UtilLog;

public class ParameterDecoratorImpl
implements IParameterDecorator {
    private Object decorated;
    protected Map<String, IAccess> checked = new HashMap<String, IAccess>();
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected Map<String, Object> allParameters = new HashMap<String, Object>();

    @Override
    public Object getDecorated() {
        return this.decorated;
    }

    @Override
    public void setDecorated(Object decorated) {
        this.decorated = decorated;
    }

    @Override
    public boolean isEval(String name) {
        return this.is(name, "_", DontEval.class);
    }

    @Override
    public boolean isSilent(String name) {
        return this.is(name, "-", Unsilent.class);
    }

    @Override
    public boolean isLate(String name) {
        IAccess access;
        boolean invert = name.contains(".");
        if (this.hasParameter(name = this.clear(name)) && (access = this.checked.get(name)) != null && access.hasFeature()) {
            boolean late = this.hasAnnotation(access, Late.class);
            if (invert) {
                late = !late;
            }
            return late;
        }
        return false;
    }

    protected boolean is(String name, String flag, Class<? extends Annotation> annotation) {
        IAccess access;
        boolean invert = name.contains(flag);
        if (this.hasParameter(name = this.clear(name)) && (access = this.checked.get(name)) != null && access.hasFeature()) {
            boolean action;
            boolean bl = action = !this.hasAnnotation(access, annotation);
            if (invert) {
                action = !action;
            }
            return action;
        }
        return true;
    }

    @Override
    public String clear(String name) {
        return name.replace("_", "").replace("-", "").replace(".", "");
    }

    @Override
    public Object getParameter(String name) {
        block3: {
            if (this.hasParameter(name)) {
                try {
                    IAccess s = this.checked.get(name);
                    return s.get(this.decorated, name, this.allParameters.get(name));
                }
                catch (Exception e) {
                    if (!UtilLog.LOG.isDebugEnabled()) break block3;
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public Object setParameter(String name, Object value, IContext context) throws Exception {
        Object newValue;
        block4: {
            newValue = value;
            String old = name;
            if (this.hasParameter(name = this.clear(name))) {
                try {
                    IAccess s = this.checked.get(name);
                    newValue = this.prepareValue(value, context, this.isEval(old), this.isSilent(old));
                    s.set(this.decorated, name, newValue);
                    this.parameters.put(name, newValue);
                }
                catch (Exception e) {
                    if (UtilLog.LOG.isTraceEnabled()) {
                        UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                    }
                    if (this.isSilent(old)) break block4;
                    throw e;
                }
            }
        }
        this.allParameters.put(name, newValue);
        return newValue;
    }

    private Object prepareValue(Object value, IContext context, boolean eval, boolean silent) throws PluginException {
        return eval ? UtilEvaluator.evaluate(String.valueOf(value), context, silent) : value;
    }

    protected boolean hasAnnotation(IAccess s, Class<? extends Annotation> an) {
        for (Annotation a : s.getAnnotations()) {
            if (a.annotationType() != an) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasParameter(String name) {
        IAccess access = this.checked.get(name);
        if (access == null) {
            access = SRServices.get(IAccessFactory.class).newAccess(this.decorated, name);
            this.checked.put(name, access);
        }
        return access != null;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Map<String, Object> getAllParameters() {
        return this.allParameters;
    }

    @Override
    public void setAllParameters(Map<String, Object> allParameters) {
        this.allParameters = allParameters;
    }
}

