/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.parameters.core;

import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Element;
import org.specrunner.SRServices;
import org.specrunner.context.IBlockFactory;
import org.specrunner.context.IContext;
import org.specrunner.parameters.IParameterDecorator;
import org.specrunner.parameters.IParameterHolder;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.PluginNop;
import org.specrunner.util.UtilLog;

public final class UtilParametrized {
    private UtilParametrized() {
    }

    public static void setProperties(IContext context, IParameterHolder holder, Element element) throws PluginException {
        UtilParametrized.setProperties(context, holder, element, true);
    }

    public static void setProperties(IContext context, IParameterHolder holder, Element element, boolean onCreate) throws PluginException {
        if (holder != null) {
            IParameterDecorator p = holder.getParameters();
            context.push(SRServices.get(IBlockFactory.class).newBlock(null, PluginNop.emptyPlugin()));
            for (int i = 0; i < element.getAttributeCount(); ++i) {
                Attribute n = element.getAttribute(i);
                String name = n.getQualifiedName();
                try {
                    boolean onEnd;
                    boolean onStart = onCreate && !p.isLate(name);
                    boolean bl = onEnd = !onCreate && p.isLate(name);
                    if (!onStart && !onEnd) continue;
                    Object newValue = p.setParameter(name, n.getValue(), context);
                    context.saveLocal(p.clear(name), newValue);
                    continue;
                }
                catch (Exception e) {
                    if (UtilLog.LOG.isTraceEnabled()) {
                        UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                    }
                    if (p.isSilent(name)) continue;
                    throw new PluginException("On expression for " + name + "=\"" + n.getValue() + "\".", e);
                }
            }
            context.pop();
        }
    }

    public static void setProperties(IContext context, IParameterHolder holder, Map<String, Object> parameters) throws PluginException {
        if (holder != null) {
            IParameterDecorator p = holder.getParameters();
            context.push(SRServices.get(IBlockFactory.class).newBlock(null, PluginNop.emptyPlugin()));
            for (Map.Entry<String, Object> e : parameters.entrySet()) {
                try {
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug("set(" + p.getDecorated() + ")." + e.getKey() + "=" + e.getValue());
                    }
                    p.setParameter(e.getKey(), e.getValue(), context);
                    context.saveLocal(e.getKey(), e.getValue());
                }
                catch (Exception ex) {
                    if (!UtilLog.LOG.isTraceEnabled()) continue;
                    UtilLog.LOG.trace(ex.getMessage(), (Throwable)ex);
                }
            }
            context.pop();
        }
    }
}

