/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.pipeline;

import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.IPipeListener;
import org.specrunner.util.UtilLog;

public class ProfilerPipeListener
implements IPipeListener {
    private long time;
    private long total;

    @Override
    public void onBeforeCheck(IChannel channel, IPipe source) {
        this.time = System.currentTimeMillis();
    }

    @Override
    public void onAfterCheck(IChannel channel, IPipe source) {
        if (UtilLog.LOG.isDebugEnabled()) {
            long t = System.currentTimeMillis() - this.time;
            this.total += t;
            UtilLog.LOG.debug("Channel (" + this.total + ") on Pipe (" + source.getClass().getSimpleName() + ") check: " + t + " ms");
        }
    }

    @Override
    public void onBeforeProcess(IChannel channel, IPipe source) {
        this.time = System.currentTimeMillis();
    }

    @Override
    public void onAfterProcess(IChannel channel, IPipe source) {
        if (UtilLog.LOG.isDebugEnabled()) {
            long t = System.currentTimeMillis() - this.time;
            this.total += t;
            UtilLog.LOG.debug("Channel (" + this.total + ") on Pipe (" + source.getClass().getSimpleName() + ") process: " + t + " ms");
        }
    }
}

