/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.pipeline.core;

import java.util.HashMap;
import java.util.Map;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.InvalidTypeException;
import org.specrunner.pipeline.NotFoundException;

public class ChannelImpl
extends HashMap<String, Object>
implements IChannel {
    public ChannelImpl() {
    }

    public ChannelImpl(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ChannelImpl(int initialCapacity) {
        super(initialCapacity);
    }

    public ChannelImpl(Map<? extends String, ? extends Object> m) {
        super(m);
    }

    @Override
    public IChannel add(String key, Object value) {
        this.put(key, value);
        return this;
    }

    @Override
    public <T> T get(String key, Class<T> type) throws NotFoundException, InvalidTypeException {
        Object obj = this.get(key);
        if (obj == null) {
            throw new NotFoundException("Channel does not contain '" + key + "'.");
        }
        if (type == null) {
            throw new NotFoundException("ActionType information cannot be null.");
        }
        Class<?> clazz = obj.getClass();
        if (!type.isAssignableFrom(clazz)) {
            throw new NotFoundException("ActionType missmatch for key '" + key + "' expected='" + type + "', received='" + clazz + "'.");
        }
        return type.cast(obj);
    }
}

