/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.pipeline.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Nodes;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.IPipeListener;
import org.specrunner.pipeline.IPipeline;
import org.specrunner.pipeline.PipelineException;
import org.specrunner.pipeline.core.PipelineFactoryImpl;
import org.specrunner.pipeline.core.PipelineImpl;
import org.specrunner.util.UtilLog;

public class PipelineFactoryXOM
extends PipelineFactoryImpl {
    protected Builder builder = this.createBuilder();

    protected Builder createBuilder() {
        return new Builder();
    }

    @Override
    public IPipeline newPipeline(Object source) throws PipelineException {
        PipelineImpl pipeline = null;
        InputStream in = null;
        try {
            int i;
            String str = String.valueOf(source);
            in = ClassLoader.getSystemResourceAsStream(str);
            if (in == null) {
                File file = new File(str);
                if (!file.exists()) {
                    throw new PipelineException("Unnable to create pipeline for file '" + file + "'.");
                }
                in = new FileInputStream(file);
            }
            Document doc = this.builder.build(in);
            Nodes nodes = doc.query("//listener");
            for (i = 0; i < nodes.size(); ++i) {
                if (pipeline == null) {
                    pipeline = new PipelineImpl();
                }
                pipeline.addPipelineListener((IPipeListener)Class.forName(nodes.get(i).getValue().trim()).newInstance());
            }
            nodes = doc.query("//pipe");
            for (i = 0; i < nodes.size(); ++i) {
                if (pipeline == null) {
                    pipeline = new PipelineImpl();
                }
                pipeline.add((IPipe)Class.forName(nodes.get(i).getValue().trim()).newInstance());
            }
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PipelineException(e);
        }
        finally {
            block18: {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        if (!UtilLog.LOG.isDebugEnabled()) break block18;
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return pipeline;
    }
}

