/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.pipeline.core;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.specrunner.pipeline.AbortException;
import org.specrunner.pipeline.IChannel;
import org.specrunner.pipeline.IPipe;
import org.specrunner.pipeline.IPipeListener;
import org.specrunner.pipeline.IPipeline;
import org.specrunner.pipeline.PipelineException;

public class PipelineImpl
extends LinkedList<IPipe>
implements IPipeline {
    protected List<IPipeListener> listeners = new LinkedList<IPipeListener>();

    public PipelineImpl() {
    }

    public PipelineImpl(Collection<? extends IPipe> c) {
        super(c);
    }

    @Override
    public boolean check(IChannel channel) throws AbortException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IChannel process(IChannel channel) throws AbortException, PipelineException {
        for (IPipe p : this) {
            boolean proceed = true;
            try {
                this.fireBeforeCheck(channel, p);
                proceed = p.check(channel);
            }
            finally {
                this.fireAfterCheck(channel, p);
            }
            if (!proceed) continue;
            try {
                this.fireBeforePerform(channel, p);
                p.process(channel);
            }
            finally {
                this.fireAfterPerform(channel, p);
            }
        }
        return channel;
    }

    @Override
    public void addPipelineListener(IPipeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removePipelineListener(IPipeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    protected void fireBeforeCheck(IChannel channel, IPipe source) {
        for (IPipeListener p : this.listeners) {
            p.onBeforeCheck(channel, source);
        }
    }

    protected void fireAfterCheck(IChannel channel, IPipe source) {
        for (IPipeListener p : this.listeners) {
            p.onAfterCheck(channel, source);
        }
    }

    protected void fireBeforePerform(IChannel channel, IPipe source) {
        for (IPipeListener p : this.listeners) {
            p.onBeforeProcess(channel, source);
        }
    }

    protected void fireAfterPerform(IChannel channel, IPipe source) {
        for (IPipeListener p : this.listeners) {
            p.onAfterProcess(channel, source);
        }
    }
}

