/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core;

import org.apache.commons.beanutils.PropertyUtils;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.context.IModel;
import org.specrunner.features.IFeatureManager;
import org.specrunner.parameters.IParameterDecorator;
import org.specrunner.parameters.core.ParameterHolder;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.IParalelPlugin;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.IPluginFactory;
import org.specrunner.plugins.ISleepPlugin;
import org.specrunner.plugins.ITestPlugin;
import org.specrunner.plugins.ITimedPlugin;
import org.specrunner.plugins.IWaitPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.result.IResultSet;
import org.specrunner.util.UtilLog;
import org.specrunner.util.UtilString;

public abstract class AbstractPlugin
extends ParameterHolder
implements IPlugin,
ITestPlugin,
IWaitPlugin,
ISleepPlugin,
ITimedPlugin,
IParalelPlugin {
    private IPluginFactory parent;
    public static final String FEATURE_CONDITION = AbstractPlugin.class.getName() + ".condition";
    private Boolean condition;
    private IModel<Boolean> conditionModel;
    public static final String FEATURE_WAIT = AbstractPlugin.class.getName() + ".wait";
    private Long wait;
    private IModel<Long> waitModel;
    public static final String FEATURE_SLEEP = AbstractPlugin.class.getName() + ".sleep";
    private Long sleep;
    private IModel<Long> sleepModel;
    public static final String FEATURE_TIMEOUT = AbstractPlugin.class.getName() + ".timeout";
    private Long timeout;
    private IModel<Long> timeoutModel;
    public static final String FEATURE_THREADSAFE = AbstractPlugin.class.getName() + ".threadsafe";
    private Boolean threadsafe;
    public static final String FEATURE_NORMALIZED = AbstractPlugin.class.getName() + ".normalized";
    private Boolean normalized = Boolean.TRUE;

    @Override
    public IPluginFactory getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IPluginFactory parent) {
        this.parent = parent;
    }

    @Override
    public void initialize(IContext context) throws PluginException {
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("initialize()>" + context.peek());
        }
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.condition == null) {
            fm.set(FEATURE_CONDITION, this);
        }
        if (this.wait == null) {
            fm.set(FEATURE_WAIT, this);
        }
        if (this.sleep == null) {
            fm.set(FEATURE_SLEEP, this);
        }
        if (this.timeout == null) {
            fm.set(FEATURE_TIMEOUT, this);
        }
        if (this.threadsafe == null) {
            fm.set(FEATURE_THREADSAFE, this);
        }
        if (this.threadsafe == null) {
            this.threadsafe = false;
        }
        fm.set(FEATURE_NORMALIZED, this);
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("doStart>" + context.peek());
        }
        return ENext.DEEP;
    }

    @Override
    public void doEnd(IContext context, IResultSet result) throws PluginException {
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("doEnd>" + context.peek());
        }
    }

    @Override
    public IPlugin copy(IContext context) throws PluginException {
        try {
            IPlugin p = (IPlugin)this.getClass().newInstance();
            IParameterDecorator decorator = p.getParameters();
            PropertyUtils.copyProperties((Object)p, (Object)this);
            p.setParameters(decorator);
            return p;
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException(e);
        }
    }

    @Override
    public Boolean getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(Boolean condition) {
        this.condition = condition;
    }

    @Override
    public IModel<Boolean> getConditionModel() {
        return this.conditionModel;
    }

    @Override
    public void setConditionModel(IModel<Boolean> conditionModel) {
        this.conditionModel = conditionModel;
    }

    @Override
    public Long getWait() {
        return this.wait;
    }

    @Override
    public void setWait(Long wait) {
        this.wait = wait;
    }

    @Override
    public IModel<Long> getWaitModel() {
        return this.waitModel;
    }

    @Override
    public void setWaitModel(IModel<Long> waitModel) {
        this.waitModel = waitModel;
    }

    @Override
    public Long getSleep() {
        return this.sleep;
    }

    @Override
    public void setSleep(Long sleep) {
        this.sleep = sleep;
    }

    @Override
    public IModel<Long> getSleepModel() {
        return this.sleepModel;
    }

    @Override
    public void setSleepModel(IModel<Long> sleepModel) {
        this.sleepModel = sleepModel;
    }

    @Override
    public Long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Override
    public IModel<Long> getTimeoutModel() {
        return this.timeoutModel;
    }

    @Override
    public void setTimeoutModel(IModel<Long> timeoutModel) {
        this.timeoutModel = timeoutModel;
    }

    @Override
    public Boolean getThreadsafe() {
        return this.threadsafe;
    }

    @Override
    public void setThreadsafe(Boolean threadsafe) {
        this.threadsafe = threadsafe;
    }

    public Boolean getNormalized() {
        return this.normalized;
    }

    public void setNormalized(Boolean normalized) {
        this.normalized = normalized;
    }

    public String getNormalized(String str) {
        if (this.getNormalized().booleanValue()) {
            return UtilString.normalize(str);
        }
        return str;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

