/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core;

import nu.xom.Node;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.util.xom.UtilNode;

public abstract class AbstractPluginDual
extends AbstractPluginValue {
    private Boolean onstart = Boolean.FALSE;

    public Boolean getOnstart() {
        return this.onstart;
    }

    public void setOnstart(Boolean onstart) {
        this.onstart = onstart;
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        if (this.onstart.booleanValue()) {
            return this.perform(context, result);
        }
        return ENext.DEEP;
    }

    @Override
    public void doEnd(IContext context, IResultSet result) throws PluginException {
        if (!this.onstart.booleanValue()) {
            this.perform(context, result);
        }
    }

    protected ENext perform(IContext context, IResultSet result) throws PluginException {
        Node node = context.getNode();
        Object obj = this.getObjectValue(context, node);
        if (this.operation(obj, context)) {
            result.addResult(Success.INSTANCE, context.newBlock(node, this));
        } else {
            result.addResult((Status)Failure.INSTANCE, context.newBlock(node, this), this.getError());
        }
        return ENext.DEEP;
    }

    protected Object getObjectValue(IContext context, Node node) throws PluginException {
        return this.isEval() ? UtilNode.newNodeHolder(node).getObject(context, true) : node.getValue();
    }

    protected abstract boolean operation(Object var1, IContext var2) throws PluginException;

    protected abstract Throwable getError();
}

