/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core;

import nu.xom.Node;
import nu.xom.ParentNode;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginScoped;
import org.specrunner.result.IResultSet;
import org.specrunner.util.UtilLog;
import org.specrunner.util.xom.TableAdapter;
import org.specrunner.util.xom.UtilNode;

public abstract class AbstractPluginTable
extends AbstractPluginScoped {
    @Override
    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("initialize()>" + context.peek());
        }
        this.initialize(context, this.getTableAdapter(context));
    }

    private TableAdapter getTableAdapter(IContext context) throws PluginException {
        Node element = context.getNode();
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("ELEMENT>" + element);
        }
        TableAdapter table = null;
        if (!(element instanceof ParentNode)) {
            throw new PluginException("IPlugin " + this.getClass().getName() + " applicable only to parent elements.");
        }
        table = UtilNode.newTableAdapter(element);
        if (!table.getQualifiedName().equalsIgnoreCase("table")) {
            throw new PluginException("IPlugin " + this.getClass().getName() + " applicable only to 'table' elements.");
        }
        return table;
    }

    public void initialize(IContext context, TableAdapter table) throws PluginException {
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("initialize(table)>" + context.peek());
        }
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("doStart>" + context.peek());
        }
        return this.doStart(context, result, this.getTableAdapter(context));
    }

    public ENext doStart(IContext context, IResultSet result, TableAdapter tableAdapter) throws PluginException {
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("doStart(table)>" + context.peek());
        }
        return ENext.DEEP;
    }

    @Override
    public void doEnd(IContext context, IResultSet result) throws PluginException {
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("doEnd>" + context.peek());
        }
        this.doEnd(context, result, this.getTableAdapter(context));
    }

    public void doEnd(IContext context, IResultSet result, TableAdapter tableAdapter) throws PluginException {
        if (UtilLog.LOG.isTraceEnabled()) {
            UtilLog.LOG.trace("doEnd(table)>" + context.peek());
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

