/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core;

import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.parameters.IParameterDecorator;
import org.specrunner.parameters.core.ParameterDecoratorImpl;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.IPluginFactory;
import org.specrunner.plugins.IPluginGroup;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.PluginNop;
import org.specrunner.plugins.type.Undefined;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.util.composite.core.CompositeImpl;

public class PluginGroupImpl
extends CompositeImpl<IPluginGroup, IPlugin>
implements IPluginGroup {
    private IPluginFactory parent;
    private IParameterDecorator parameters = new ParameterDecoratorImpl(){

        @Override
        public Object setParameter(String name, Object value, IContext context) throws Exception {
            for (IPlugin p : PluginGroupImpl.this.getChildren()) {
                p.getParameters().setParameter(name, value, context);
            }
            return super.setParameter(name, value, context);
        }
    };

    public PluginGroupImpl() {
        this.parameters.setDecorated(this);
    }

    @Override
    public IPluginFactory getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IPluginFactory parent) {
        this.parent = parent;
    }

    @Override
    public IPluginGroup add(IPlugin child) {
        if (child != PluginNop.emptyPlugin() && !this.getChildren().contains(child)) {
            return (IPluginGroup)super.add(child);
        }
        return this;
    }

    @Override
    public IPlugin getNormalized() {
        return !this.isEmpty() ? (this.getChildren().size() == 1 ? (IPlugin)this.getChildren().get(0) : this) : PluginNop.emptyPlugin();
    }

    @Override
    public ActionType getActionType() {
        return Undefined.INSTANCE;
    }

    @Override
    public void initialize(IContext context) throws PluginException {
        for (IPlugin p : this.getChildren()) {
            p.initialize(context);
        }
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        ENext exit = ENext.DEEP;
        for (IPlugin p : this.getChildren()) {
            try {
                ENext n = p.doStart(context, result);
                if (n == ENext.SKIP) {
                    exit = ENext.SKIP;
                }
                if (!context.isChanged()) continue;
                break;
            }
            catch (Exception e) {
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), e);
            }
        }
        return exit;
    }

    @Override
    public void doEnd(IContext context, IResultSet result) throws PluginException {
        for (IPlugin p : this.getChildren()) {
            try {
                p.doEnd(context, result);
            }
            catch (Exception e) {
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), e);
            }
        }
    }

    @Override
    public IPlugin copy(IContext context) throws PluginException {
        PluginGroupImpl group = new PluginGroupImpl();
        for (IPlugin p : this.getChildren()) {
            group.add(p.copy(context));
        }
        return group;
    }

    @Override
    public IParameterDecorator getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(IParameterDecorator parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        return "GROUP" + this.getChildren();
    }
}

