/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core;

import java.util.Arrays;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.SRServices;
import org.specrunner.comparators.IComparator;
import org.specrunner.context.IBlockFactory;
import org.specrunner.context.IContext;
import org.specrunner.parameters.IParameterHolder;
import org.specrunner.parameters.core.UtilParametrized;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.PluginNop;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.runner.IFilter;
import org.specrunner.runner.IRunner;
import org.specrunner.runner.RunnerException;
import org.specrunner.runner.core.FilterDefault;
import org.specrunner.util.UtilLog;
import org.specrunner.util.aligner.core.DefaultAlignmentException;

public final class UtilPlugin {
    private UtilPlugin() {
    }

    public static <T extends IPlugin> T create(IContext context, Class<T> type, Element element) throws PluginException {
        return UtilPlugin.create(context, type, element, false);
    }

    public static IPlugin create(IContext context, IPlugin instance, Element element) throws PluginException {
        return UtilPlugin.create(context, instance, element, false);
    }

    public static <T extends IPlugin> T create(IContext context, Class<T> type, Element element, boolean initialize) throws PluginException {
        try {
            IPlugin result = (IPlugin)type.newInstance();
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("result ->" + result);
            }
            if (initialize) {
                UtilParametrized.setProperties(context, (IParameterHolder)result, element);
                result.initialize(context);
            }
            return (T)result;
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException("Could not create a plugin for " + type + "." + e.getMessage(), e);
        }
    }

    public static IPlugin create(IContext context, IPlugin instance, Element element, boolean initialize) throws PluginException {
        try {
            IPlugin result = instance.copy(context);
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("result ->" + result);
            }
            if (initialize) {
                UtilParametrized.setProperties(context, (IParameterHolder)result, element);
                result.initialize(context);
            }
            return result;
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException("Could not create a plugin for " + instance + "." + e.getMessage(), e);
        }
    }

    public static IPlugin destroy(IContext context, IPlugin plugin, Element element) throws PluginException {
        try {
            if (plugin != PluginNop.emptyPlugin()) {
                UtilParametrized.setProperties(context, plugin, element, false);
            }
            return plugin;
        }
        catch (Exception e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException("Could not finalize plugin " + plugin + "." + e.getMessage(), e);
        }
    }

    public static void performChildren(Node node, IContext context, IResultSet result) throws PluginException {
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node t = node.getChild(i);
            try {
                context.getRunner().run(t, context, result);
                continue;
            }
            catch (RunnerException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new PluginException(e);
            }
        }
    }

    public static void performComandsFirst(IContext context, IResultSet result, Node element) throws PluginException {
        IRunner runner = context.getRunner();
        IFilter filter = runner.getFilter();
        FilterDefault tmp = FilterDefault.INSTANCE.get();
        List<? extends ActionType> types = tmp.getDisabledTypes();
        boolean show = tmp.isShowMessage();
        try {
            tmp.setEnabledTypes(Arrays.asList(Command.INSTANCE));
            tmp.setShowMessage(false);
            runner.setFilter(tmp);
            UtilPlugin.performChildren(element, context, result);
            tmp.setEnabledTypes(null);
            runner.run(element, context, result);
        }
        catch (RunnerException e) {
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw new PluginException(e.getMessage(), e);
        }
        finally {
            tmp.setDisabledTypes(types);
            tmp.setShowMessage(show);
            runner.setFilter(filter);
        }
    }

    public static void compare(Node node, IResultSet result, Object expected, Object received) throws PluginException {
        UtilPlugin.compare(node, null, result, (IComparator)SRServices.getComparatorManager().getDefault(), expected, received);
    }

    public static void compare(Node node, IPlugin plugin, IResultSet result, IComparator comparator, Object expected, Object received) throws PluginException {
        if (comparator.match(expected, received)) {
            result.addResult(Success.INSTANCE, SRServices.get(IBlockFactory.class).newBlock(node, plugin));
        } else {
            result.addResult((Status)Failure.INSTANCE, SRServices.get(IBlockFactory.class).newBlock(node, plugin), new DefaultAlignmentException(String.valueOf(expected), String.valueOf(received)));
        }
    }
}

