/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nu.xom.Node;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginTable;
import org.specrunner.plugins.core.data.IDataMap;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.status.Success;
import org.specrunner.util.xom.CellAdapter;
import org.specrunner.util.xom.RowAdapter;
import org.specrunner.util.xom.TableAdapter;

public class PluginMap
extends AbstractPluginTable {
    private Boolean after = false;

    public Boolean getAfter() {
        return this.after;
    }

    public void setAfter(Boolean after) {
        this.after = after;
    }

    @Override
    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    @Override
    public ENext doStart(IContext context, IResultSet result, TableAdapter tableAdapter) throws PluginException {
        if (!this.after.booleanValue()) {
            this.process(context, result, tableAdapter);
            return ENext.SKIP;
        }
        return ENext.DEEP;
    }

    @Override
    public void doEnd(IContext context, IResultSet result, TableAdapter tableAdapter) throws PluginException {
        if (this.after.booleanValue()) {
            this.process(context, result, tableAdapter);
        }
    }

    private void process(IContext context, IResultSet result, TableAdapter tableAdapter) throws PluginException {
        final LinkedList data = new LinkedList();
        if (tableAdapter.getRowCount() == 0) {
            throw new PluginException("Table must not be empty.");
        }
        RowAdapter ths = tableAdapter.getRow(0);
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 0; i < ths.getCellsCount(); ++i) {
            names.add(String.valueOf(ths.getCell(i).getObject(context, true)).trim());
        }
        List<RowAdapter> trs = tableAdapter.getRows();
        for (int i = 1; i < tableAdapter.getRowCount(); ++i) {
            RowAdapter tr = trs.get(i);
            if (tr.getCellsCount() != ths.getCellsCount()) {
                throw new PluginException("Number of headers '" + ths.getCellsCount() + "' is diferent from line columns '" + tr.getCellsCount() + "'.");
            }
            List<CellAdapter> tds = tr.getCells();
            HashMap<String, Node> line = new HashMap<String, Node>();
            data.add(line);
            for (int j = 0; j < tds.size(); ++j) {
                Node e = tds.get(j).getNode();
                line.put("#{" + j + "}", e);
                line.put("#{" + (String)names.get(j) + "}", e);
            }
        }
        IDataMap<Node> map = new IDataMap<Node>(){

            @Override
            public int getTotal() {
                return data.size();
            }

            @Override
            public Iterator<Map<String, Node>> iterator() {
                return data.iterator();
            }
        };
        this.saveLocal(context, this.getName(), map);
        for (int i = 0; i < ths.getCellsCount(); ++i) {
            result.addResult(Success.INSTANCE, context.newBlock(ths.getCell(i).getNode(), this));
        }
    }
}

