/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.elements;

import java.io.File;
import nu.xom.Attribute;
import nu.xom.Element;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.dumper.core.AbstractSourceDumperFile;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.elements.AbstractPluginResource;
import org.specrunner.plugins.type.Undefined;
import org.specrunner.result.IResultSet;
import org.specrunner.source.ISource;
import org.specrunner.source.ISourceFactory;
import org.specrunner.source.SourceException;
import org.specrunner.util.UtilLog;

public abstract class AbstractPluginResourceReplaceable
extends AbstractPluginResource {
    private static ThreadLocal<Integer> serialNumber = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    @Override
    public ActionType getActionType() {
        return Undefined.INSTANCE;
    }

    @Override
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        String reference = this.getReferenceValue();
        if (reference != null && this.isSave()) {
            try {
                Element element = (Element)context.getNode();
                ISource source = context.getCurrentSource();
                ISourceFactory sourceFactory = source.getFactory();
                ISource referencedSource = sourceFactory.newSource(reference);
                ISource relative = source.resolve(referencedSource);
                String path = String.valueOf(relative.getURI());
                this.addResource(source, path, element);
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Resource " + reference + " from source " + source.getString() + " added.");
                }
                File file = null;
                File outDir = (File)SRServices.getFeatureManager().get(AbstractSourceDumperFile.FEATURE_OUTPUT_DIRECTORY);
                String outFile = (String)SRServices.getFeatureManager().get(AbstractSourceDumperFile.FEATURE_OUTPUT_NAME);
                if (outDir != null || outFile != null) {
                    file = new File(outDir, outFile);
                } else {
                    ISource first = context.getSources().getLast();
                    file = first.getFile();
                }
                String newName = file.getName() + "_res/" + serialNumber.get() + "_" + path.substring(path.lastIndexOf(47) + 1);
                serialNumber.set(serialNumber.get() + 1);
                this.replaceName(element, newName);
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Added to " + file + " as " + newName + ".");
                }
            }
            catch (SourceException e) {
                throw new PluginException(e);
            }
        }
        return ENext.DEEP;
    }

    protected abstract String getReferenceName();

    protected abstract String getReferenceValue();

    protected abstract void addResource(ISource var1, String var2, Element var3);

    protected void replaceName(Element element, String newName) {
        element.addAttribute(new Attribute(this.getReferenceName(), newName));
    }
}

