/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.factories;

import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.context.IContext;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.IPluginGroup;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.PluginKind;
import org.specrunner.plugins.core.PluginGroupImpl;
import org.specrunner.plugins.core.PluginNop;
import org.specrunner.plugins.core.UtilPlugin;
import org.specrunner.plugins.core.factories.PluginFactoryImpl;

public class PluginFactoryAttribute
extends PluginFactoryImpl {
    public PluginFactoryAttribute() {
        super("sr_plugins_attribute.properties", PluginKind.ATTRIBUTE);
    }

    @Override
    public IPlugin newPlugin(Node node, IContext context) throws PluginException {
        this.initialize();
        if (node instanceof Element) {
            PluginGroupImpl result = new PluginGroupImpl();
            Element ele = (Element)node;
            if (this.typeNamesToAlias.size() + this.templates.size() < ele.getAttributeCount()) {
                this.byMapping(context, result, ele);
            } else {
                this.byAttribute(context, result, ele);
            }
            return result.getNormalized();
        }
        return PluginNop.emptyPlugin();
    }

    private void byMapping(IContext context, IPluginGroup result, Element ele) throws PluginException {
        Attribute att;
        for (Map.Entry e : this.templates.entrySet()) {
            att = ele.getAttribute((String)e.getKey());
            if (att == null) continue;
            IPlugin create = UtilPlugin.create(context, (IPlugin)e.getValue(), ele);
            create.setParent(this);
            result.add(create);
        }
        for (Map.Entry e : this.aliasToTypes.entrySet()) {
            Class c;
            att = ele.getAttribute((String)e.getKey());
            if (att == null || (c = (Class)this.aliasToTypes.get(e.getKey())) == null) continue;
            Object create = UtilPlugin.create(context, c, ele);
            create.setParent(this);
            result.add(create);
        }
    }

    protected void byAttribute(IContext context, IPluginGroup result, Element ele) throws PluginException {
        for (int i = 0; i < ele.getAttributeCount(); ++i) {
            Attribute att = ele.getAttribute(i);
            String name = att.getQualifiedName();
            IPlugin template = (IPlugin)this.templates.get(name);
            IPlugin create = null;
            if (template != null) {
                create = UtilPlugin.create(context, template, ele);
            } else {
                Class<? extends IPlugin> c = this.getClass(name);
                if (c != null) {
                    create = UtilPlugin.create(context, c, ele);
                }
            }
            if (create == null) continue;
            create.setParent(this);
            result.add(create);
        }
    }
}

