/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.plugins.core.factories;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.plugins.IPlugin;
import org.specrunner.plugins.IPluginFactory;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.PluginKind;
import org.specrunner.plugins.core.PluginNop;
import org.specrunner.plugins.core.UtilPlugin;
import org.specrunner.properties.IPropertyLoader;
import org.specrunner.util.UtilLog;

public abstract class PluginFactoryImpl
implements IPluginFactory {
    private PluginKind kind;
    protected Map<String, String> aliasToTypeNames = new HashMap<String, String>();
    protected Map<String, Class<? extends IPlugin>> aliasToTypes = new HashMap<String, Class<? extends IPlugin>>();
    protected Map<String, IPlugin> templates = new HashMap<String, IPlugin>();
    protected Map<String, String> typeNamesToAlias = new HashMap<String, String>();
    private String file;
    private boolean initialized = false;

    protected PluginFactoryImpl(String file, PluginKind kind) {
        if (file != null) {
            this.file = file;
        }
        this.kind = kind;
    }

    public PluginKind getKind() {
        return this.kind;
    }

    public void initialize() throws PluginException {
        if (!this.initialized) {
            try {
                List<Properties> list = SRServices.get(IPropertyLoader.class).load(this.file);
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("properties list=" + list);
                }
                for (Properties p : list) {
                    for (Map.Entry<Object, Object> e : p.entrySet()) {
                        String key = String.valueOf(e.getKey()).toLowerCase();
                        String value = String.valueOf(e.getValue());
                        this.aliasToTypeNames.put(key, value);
                        this.typeNamesToAlias.put(value, key);
                    }
                }
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("properties loaded: " + this.file);
                }
            }
            catch (Exception e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new PluginException(e);
            }
            this.initialized = true;
        }
    }

    @Override
    public Class<? extends IPlugin> getClass(String alias) throws PluginException {
        String type = this.aliasToTypeNames.get(alias);
        if (type == null) {
            return null;
        }
        Class<IPlugin> c = this.aliasToTypes.get(alias);
        if (c == null) {
            try {
                c = Class.forName(type);
            }
            catch (Exception e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new PluginException(e);
            }
            this.aliasToTypes.put(alias, c);
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("put(" + alias + "," + c + ")");
            }
        }
        return c;
    }

    @Override
    public String getAlias(Class<? extends IPlugin> type) throws PluginException {
        this.initialize();
        if (type == null) {
            return null;
        }
        return this.typeNamesToAlias.get(type.getName());
    }

    @Override
    public IPluginFactory bind(PluginKind kind, String alias, IPlugin plugin) throws PluginException {
        if (kind == null || alias == null || plugin == null) {
            throw new PluginException("Ivalid bind, all arguments must be not null. Current bind (" + kind + "," + alias + "," + plugin + ")");
        }
        if (this.test(kind)) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("put(" + alias + "," + plugin + ")");
            }
            this.templates.put(alias.toLowerCase(), plugin);
        }
        return this;
    }

    protected boolean test(PluginKind type) {
        return this.kind.equals(type);
    }

    @Override
    public boolean finalizePlugin(Node source, IContext context, IPlugin plugin) throws PluginException {
        if (plugin == null) {
            return false;
        }
        if (plugin instanceof PluginNop) {
            return false;
        }
        if (source instanceof Element && plugin.getParent() == this) {
            Element ele = (Element)source;
            UtilPlugin.destroy(context, plugin, ele);
            return true;
        }
        return false;
    }
}

